{
  $Project$
  $Workfile$
  $Revision$
  $DateUTC$
  $Id$

  This file is part of the Indy (Internet Direct) project, and is offered
  under the dual-licensing agreement described on the Indy website.
  (http://www.indyproject.org/)

  Copyright:
   (c) 1993-2005, Chad Z. Hower and the Indy Pit Crew. All rights reserved.
}
{
  $Log$
}
{
    Rev 1.2    10/15/2003 12:48:32 PM  DSiders
  Added l,ocalization comments.
}
{
{   Rev 1.1    1/31/2003 02:54:04 PM  JPMugaas
{ Updated with IdContext.pas.
}
{
{   Rev 1.0    11/13/2002 08:37:54 AM  JPMugaas
}
unit IdAssignedNumbers;

interface

{These values are all from RFC 1700}

const  {Port values}
  IdPORT_TCPMUX  = 1;
  IdPORT_COMPRESSNET_MGM = 2; //Management Utility
  IdPORT_COMPRESSNET_CMP = 3; //Compression Proces
  IdPORT_RJE     = 5;  //Remote Job Entry
  IdPORT_ECHO    = 7;
  IdPORT_DISCARD = 9;
  IdPORT_SYSTAT  = 11;
  IdPORT_DAYTIME = 13;
  IdPORT_NETSTAT = 15;
  IdPORT_QOTD    = 17;
  IdPORT_MSP     = 18;  //Message Send Protocol
  IdPORT_CHARGEN = 19; {UDP Server!}
  IdPORT_FTP_DATA = 20; //FTP Data default port
  IdPORT_FTP     = 21;
  IdPORT_SSH     = 22; //SSH Remote Login Protocol
  IdPORT_TELNET  = 23;
  IdPORT_ANYTERMINIL = 24; //any private mail system
  IdPORT_SMTP    = 25;
  IdPORT_NSW_FE  = 27; //NSW New User System FE
  IdPORT_MSG_ICMP = 29;
  IdPORT_MSG_AUTH = 31; //MSG Authentication
  IdPORT_DSP     = 33; //Display Support Protocol
  IdPORT_ANYPRINTER = 34; //any private printer server

  IdPORT_TIME    = 37;
  IdPORT_RAP     = 38; //Remote Access Protocol
  IdPORT_RLP     = 39; //Resource Location Protocol
  IdPORT_GRAPHICS = 41; //Graphics
  IdPORT_NAMESERVER = 42;  //Host Name Server
  IdPORT_WHOIS   = 43;
  IdPORT_MPM_FLAGS = 44; //MPM Flags Protocol
  IdPORT_MPM       = 45; //Message Processing Protocol
  IdPORT_MPM_SND   = 46; //MPM (Default Send)
  IdPORT_NI_FTP    = 47;
  IdPORT_AUDITD    = 48; //Digital Audit Daemon
  IdPORT_BBN_LOGIN = 49; //Login Host Protocol
  IdPORT_RE_MAIL_CK = 50; //Remote Mail Checking Protocol
  IdPORT_LA_MAINT  = 51; //IMP Logical Address Maintenance
  IdPORT_XNS_TIME  = 52; //XNS Time Protocol
  IdPORT_DOMAIN  = 53;
  IdPORT_XNS_CH  = 54; //XNS Clearinghouse
  IdPORT_ISI_GL  = 55; //ISI Graphics Language
  IdPORT_XNS_AUTH = 56; //XNS Authentication
  IdPORT_ANYPRIVATE_TERMINAL = 57; //any private terminal access
  IdPORT_XNS_MAIL = 58; //XNS Mail
  IdPORT_ANY_FILE = 59; // Any private file service

  IdPORT_NI_MAIL = 61;
  IdPORT_ACAS    = 62; //ACA Services
  IdPORT_WHOIS_PLUS = 63; //WhoIs++
  IdPORT_COVIA   = 64;  //Communications Integrator (CI)
  IdPORT_TACACS_DS = 65; //  TACACS-Database Service
  IdPORT_SQLNET = 66; //Oracle SQL*NET
  IdPORT_BOOTPS = 67; //Bootstrap Protocol Server - DHCP uses this as well
  IdPORT_BOOTPC = 68; //Bootstrap Protocol Client - DHCP uses this as well
  IdPORT_TFTP    = 69;
  IdPORT_GOPHER  = 70;
  IdPORT_NETRJS1 = 71; //Network Job Service
  IdPORT_NETRJS2 = 72;
  IdPORT_NETRJS3 = 73;
  IdPORT_NETRJS4 = 74;
  IdPORT_ANYDIAL = 75; //Any dial-out service
  IdPORT_DEOS    = 76; //Distributed External Object Store
  IdPORT_ANYRJE  = 77; //Any RJE Service
  IdPORT_VETTCP  = 78;
  IdPORT_FINGER  = 79;
  IdPORT_HTTP    = 80;
  IdPORT_HOSTS2_NS = 81; //HOSTS2 Name Server
  IdPORT_XFER    = 82; //XFER Utility
  IdPORT_MIT_ML_DEV = 83; //MIT ML Device
  IdPORT_CTF     = 84; //Common Trace Facility
  IdPORT_MIT_ML_DEV2 = 85; //MIT ML Device
  IdPORT_MFCOBOL = 86; //Micro Focus Cobol
  IdPORT_ANYTERMINALLINK = 87; //Any private terminal link
  IdPORT_KERBEROS = 88; //kerberos
  IdPORT_SU_MIT_TG = 89; //SU/MIT Telnet Gateway
  IdPORT_DNSIX = 90; // DNSIX Securit Attribute Token Map
  IdPORT_MIT_DOV = 91; //MIT Dover Spooler
  IdPORT_NPP = 92; //Network Printing Protocol
  IdPORT_DCP = 93; //Device Control Protocol
  IdPORT_OBJCALL = 94; //Tivoli Object Dispatcher
  IdPORT_SUPDUP = 95; //SUPDUP
  IdPORT_DIXIE = 96;  //DIXIE Protocol Specification
  IdPORT_SWIFT_RVF = 97; //Swift Remote Virtural File Protocol
  IdPORT_TACNEWS = 98; //TAC News
  IdPORT_METAGRAM = 99; //    Metagram Relay
  IdPORT_NEWACCT = 100; //    [unauthorized use]
  IdPORT_HOSTNAME = 101;
  IdPORT_ISO_TSAP = 102; // ISO-TSAP Class 0
  IdPORT_GPPITNP = 103; // Genesis Point-to-Point Trans Net
  IdPORT_ACR_NAME = 104; //ACR-NEMA Digital Imag. & Comm. 300
  IdPORT_CSNET_NS = 105; //  Mailbox Name Nameserver
  IdPORT_3COM_TSMUX = 106; //  3COM-TSMUX
  IdPORT_RTELNET = 107;// Remote Telnet Service
  IdPORT_SNAGAS  = 108;// SNA Gateway Access Server
  IdPORT_POP2    = 109;
  IdPORT_POP3    = 110;
  IdPORT_SUNRPC  = 111;// SUN Remote Procedure Call
  IdPORT_McIDAS  = 112;// McIDAS Data Transmission Protocol
  {This is called AUT in the RFC.  The protocol was renamed to IdentD to better
  refect what the protocol was doing}
  IdPORT_AUTH    = 113;
  IdPORT_AUDIONEWS = 114;//  Audio News Multicast
  IdPORT_SFTP = 115; //tcp  Simple File Transfer Protocol
  IdPORT_ANSANOTIFY = 116; //  ANSA REX Notify
  IdPORT_UUCP_PATH = 117; // UUCP Path Service
  IdPORT_SQLSERV = 118;//tcp    SQL Services
  IdPORT_NNTP    = 119;
  IdPORT_CFDPTKT = 120;//tcp    CFDPTKT
  IdPORT_ERPC = 121;//tcp    Encore Expedited Remote Pro.Call
  IdPORT_SMAKYNET = 122;//tcp    SMAKYNET
  IdPORT_SNTP    = 123;
  IdPORT_ANASTRADER = 124;// ANSA REX Trader
  IdPORT_LOCUS_MAP = 125;// Locus PC-Interface Net Map Ser
  IdPORT_UNITARY = 126;// Unisys Unitary Login
  IdPORT_locus_con = 127;// Locus PC-Interface Conn Server
  IdPORT_GSS_XLICEN = 128;//  GSS X License Verification
  IdPORT_PWDGEN = 129;//    Password Generator Protocol
  IdPORT_CISCO_FNA = 130;// cisco FNATIVE
  IdPORT_cisco_tna = 131;// cisco TNATIVE
  IdPORT_cisco_sys = 132;//cisco SYSMAINT
  IdPORT_statsrv = 133;// Statistics Service
  IdPORT_ingres_net = 134;//INGRES-NET Service
  IdPORT_loc_srv = 135;//Location Service
  IdPORT_profile = 136;// PROFILE Naming System
  IdPORT_netbios_ns = 137;//  NETBIOS Name Service
  IdPORT_netbios_dgm = 138;// NETBIOS Datagram Service
  IdPORT_netbios_ssn = 139;// NETBIOS Session Service
  IdPORT_emfis_data = 140;//  EMFIS Data Service
  IdPORT_emfis_cntl = 141;// EMFIS Control Service
  IdPORT_bl_idm     = 142;//Britton-Lee IDM
  IdPORT_IMAP4      = 143;
  IdPORT_news       = 144;//NewS
  IdPORT_uaac       = 145;//UAAC Protocol
  IdPORT_iso_tp0    = 146;//ISO-IP0
  IdPORT_iso_ip     = 147;//ISO-IP
  IdPORT_cronus     = 148;//CRONUS-SUPPORT
  IdPORT_aed_512    = 149;//AED 512 Emulation Service
  IdPORT_sql_net    = 150;//SQL-NET
  IdPORT_hems       = 151;//HEMS
  IdPORT_bftp       = 152;// Background File Transfer Program
  IdPORT_sgmp       = 153;// SGMP
  IdPORT_netsc_prod = 154;// NETSC
  IdPORT_netsc_dev  = 155;// NETSC
  IdPORT_sqlsrv     = 156;// SQL Service
  IdPORT_knet_cmp   = 157;// KNET/VM Command/Message Protocol
  IdPORT_pcmail_srv = 158;// PCMail Server
  IdPORT_nss_routing = 159;// NSS-Routing
  IdPORT_sgmp_traps  = 160;// SGMP-TRAPS
  IdPORT_snmp        = 161;// SNMP
  IdPORT_snmptrap    = 162;// SNMPTRAP
  IdPORT_cmip_man    = 163;// CMIP/TCP Manager
  IdPORT_cmip_agent  = 164;// CMIP/TCP Agent
  IdPORT_xns_courier = 165;// Xerox
  IdPORT_s_net       = 166;// Sirius Systems
  IdPORT_namp        = 167;// NAMP
  IdPORT_rsvd        = 168;// tcp    RSVD
  IdPORT_send        = 169;//tcp    SEND
  IdPORT_print_srv   = 170;//tcp    Network PostScript
  IdPORT_multiplex   = 171;// Network Innovations Multiplex
  IdPORT_cl_1        = 172;//Network Innovations CL/1
  IdPORT_xyplex_mux  = 173;//Xyplex
  IdPORT_mailq      = 174; //    MAILQ
  IdPORT_vmnet       = 175;//  VMNET
  IdPORT_genrad_mux   = 176;//   GENRAD-MUX
  IdPORT_xdmcp        = 177;// X Display Manager Control Protocol
  IdPORT_NextStep     = 178;//    NextStep Window Server
  IdPORT_bgp          = 179;//    Border Gateway Protocol
  IdPORT_ris          = 180;//  Intergraph
  IdPORT_unify        = 181;//  Unify
  IdPORT_audit        = 182;//   Unisys Audit SITP
  IdPORT_ocbinder     = 183;//    OCBinder
  IdPORT_ocserver     = 184;//    OCServer
  IdPORT_remote_kis   = 185;//   Remote-KIS
  IdPORT_kis          = 186;//    KIS Protocol
  IdPORT_aci          = 187;//   Application Communication Interface
  IdPORT_mumps        = 188;// Plus Five's MUMPS    {Do not Localize}
  IdPORT_qft          = 189;// Queued File Transport
  IdPORT_gacp         = 190;//   Gateway Access Control Protocol
  IdPORT_prospero     = 191;//  Prospero Directory Service
  IdPORT_osu_nms      = 192;//  OSU Network Monitoring System
  IdPORT_srmp         = 193;// Spider Remote Monitoring Protocol
{not sure about this one
irc             194/tcp    Internet Relay Chat Protocol
irc             194/udp    Internet Relay Chat Protocol
#                          Jarkko Oikarinen <jto@TOLSUN.OULU.FI>
}
  IdPORT_dn6_nlm_aud  = 195;// DNSIX Network Level Module Audit
  IdPORT_dn6_smm_red  = 196;// DNSIX Session Mgt Module Audit Redir
  IdPORT_dls          = 197;// Directory Location Service
  IdPORT_dls_mon      = 198;// Directory Location Service Monitor
  IdPORT_smux         = 199;//SMUX
  IdPORT_src          = 200;//IBM System Resource Controller
  IdPORT_at_rtmp      = 201;//AppleTalk Routing Maintenance
  IdPORT_at_nbp       = 202;//ppleTalk Name Binding
  IdPORT_at_3         = 203;//AppleTalk Unused
  IdPORT_at_echo      = 204;//AppleTalk Echo
  IdPORT_at_5         = 205;//AppleTalk Unused
  IdPORT_at_zis       = 206;//AppleTalk Zone Information
  IdPORT_at_7         = 207;//AppleTalk Unused
  IdPORT_at_8         = 208;//AppleTalk Unused
  IdPORT_qmtp         = 209;//the Quick Mail Transfer Protocol
  IdPORT_z39_50       = 210;//ANSI Z39.50
  IdPORT_914c_g       = 211;//Texas Instruments 914C/G Terminal
  IdPORT_anet         = 212;//ATEXSSTR
  IdPORT_ipx          = 213;//IPX
  IdPORT_vmpwscs      = 214;//VM PWSCS
  IdPORT_softpc       = 215;//Insignia Solutions
  IdPORT_CAIlic       = 216;//Computer Associates Int'l License Server    {Do not Localize}
  IdPORT_dbase        = 217;//dBASE Unix
  IdPORT_mpp          = 218;// Netix Message Posting Protocol
  IdPORT_uarps        = 219;// Unisys ARPs
  IdPORT_imap3        = 220;// Interactive Mail Access Protocol v3
  IdPORT_fln_spx      = 221;// Berkeley rlogind with SPX auth
  IdPORT_rsh_spx      = 222;// Berkeley rshd with SPX auth
  IdPORT_cdc          = 223;//Certificate Distribution Center
  Id_PORT_masqdialer  = 224;//tcp    masqdialer

  Id_PORT_direct      = 242;//tcp    Direct
  IdPORT_sur_meas     = 243;// Survey Measurement
  Id_PORT_inbusiness  = 244;//tcp    inbusiness
  IdPORT_link         = 245;// LINK
  IdPORT_dsp3270      = 246;// Display Systems Protocol
  IdPORT_pdap         = 344;// Prospero Data Access Protocol
  IdPORT_pawserv      = 345;// Perf Analysis Workbench
  IdPORT_zserv        = 346;//Zebra server
  IdPORT_fatserv      = 347;//Fatmen Server
  IdPORT_csi_sgwp     = 348;//Cabletron Management Protocol
  Id_PORT_mftp        = 349; //mftp
  Id_PORT_matip_type_a = 350; //MATIP Type A
  Id_PORT_matip_type_b = 351; //MATIP Type B
  Id_PORT_dtag_ste_sb  = 352; //DTAG
  Id_PORT_ndsauth = 353; //ndsauth
  Id_PORT_bh611 = 354; //bh611
  Id_PORT_datex_asn = 355; //datex-asn
  Id_PORT_cloanto_net_1 = 356; //Cloanto Net 1
  Id_PORT_bhevent = 357; //bhevent
  Id_PORT_shrinkwrap  = 358; //Shrinkwrap
  Id_PORT_nsrmp	      = 359;//tcp    Network Security Risk Management Protocol
  Id_PORT_scoi2odialog	= 360;//tcp    scoi2odialog
  Id_PORT_semantix    = 361;//tcp    Semantix
  Id_PORT_srssend     = 362;//tcp    SRS Sen
  Id_PORT_rsvp_tunnel =	363;//tcp    RSVP Tunnel
  Id_PORT_aurora_cmgr = 364;//tcp    Aurora CMGR
  Id_PORT_dtk         = 365;//tcp    DTK
  Id_PORT_odmr        = 366;//tcp    ODMR
  Id_PORT_mortgageware = 367;//tcp    MortgageWare
  Id_PORT_qbikgdp     = 368;//tcp    QbikGDP
  Id_PORT_rpc2portmap = 369;//tcp    rpc2portmap
  Id_PORT_codaauth2   = 370;//tcp    codaauth2
  IdPORT_clearcase    = 371;//Clearcase
  IdPORT_ulistserv    = 372;//Unix Listserv
  IdPORT_legent_1     = 373;//Legent Corporation
  IdPORT_legent_2     = 374;//Legent Corporation
  IdPORT_hassle       = 375;//Hassle
  IdPORT_nip          = 376; // Amiga Envoy Network Inquiry Proto
  IdPORT_tnETOS       = 377;//NEC Corporation
  IdPORT_dsETOS       = 378;//NEC Corporation
  IdPORT_is99c        = 379;//TIA/EIA/IS-99 modem client
  IdPORT_is99s        = 380;//TIA/EIA/IS-99 modem server
  IdPORT_hp_collector = 381;//hp performance data collector
  IdPORT_hp_managed_node = 382;//hp performance data managed node
  IdPORT_hp_alarm_mgr  = 383;//hp performance data alarm manager
  IdPORT_arns          = 384;//A Remote Network Server System
  IdPORT_ibm_app       = 385;//IBM Application
  IdPORT_asa           = 386;//ASA Message Router Object Def.
  IdPORT_aurp          = 387;//Appletalk Update-Based Routing Pro.
  IdPORT_unidata_ldm   = 388;//Unidata LDM Version 4
  IdPORT_ldap          = 389;//Lightweight Directory Access Protocol
  IdPORT_uis           = 390;//UIS
  IdPORT_synotics_relay = 391;//SynOptics SNMP Relay Port
  IdPORT_synotics_broker = 392;//SynOptics Port Broker Port
  IdPORT_dis            = 393;//Data Interpretation System
  IdPORT_embl_ndt       = 394;//EMBL Nucleic Data Transfer
  IdPORT_etcp           = 395;//NETscout Control Protocol
  IdPORT_netware_ip     = 396;//Novell Netware over IP
  IdPORT_mptn           = 397;//Multi Protocol Trans. Net.
  IdPORT_kryptolan      = 398;//Kryptolan
  IdPORT_iso_tsap_c2    = 399;//ISO Transport Class 2 Non-Control over TCP
  IdPORT_work_sol       = 400;//Workstation Solutions
  IdPORT_ups            = 401;//Uninterruptible Power Supply
  IdPORT_genie          = 402;//Genie Protocol
  IdPORT_decap          = 403;//decap
  IdPORT_nced           = 404;//nced
  IdPORT_ncld           = 405;//ncld
  IdPORT_imsp           = 406;//Interactive Mail Support Protocol
  IdPORT_timbuktu       = 407;//Timbuktu
  IdPORT_prm_sm         = 408;//Prospero Resource Manager Sys. Man.
  IdPORT_prm_nm         = 409;//Prospero Resource Manager Node Man.
  IdPORT_decladebug     = 410;//DECLadebug Remote Debug Protocol
  IdPORT_rmt            = 411;//Remote MT Protocol
  IdPORT_synoptics_trap = 412;//Trap Convention Port
  IdPORT_smsp           = 413;//SMSP
  IdPORT_infoseek       = 414;//InfoSeek
  IdPORT_bnet           = 415;//BNet
  IdPORT_silverplatter  = 416;//Silverplatter
  IdPORT_onmux          = 417;//Onmux
  IdPORT_hyper_g        = 418;//Hyper-G
  IdPORT_ariel1         = 419;//Ariel
  IdPORT_smpte          = 420;//SMPTE
  IdPORT_ariel2         = 421;//Ariel
  IdPORT_ariel3         = 422;//Ariel
  IdPORT_opc_job_start  = 423;//IBM Operations Planning and Control Start
  IdPORT_opc_job_track  = 424;//IBM Operations Planning and Control Track
  IdPORT_icad_el        = 425;//ICAD
  IdPORT_smartsdp       = 426;//smartsdp
  IdPORT_svrloc         = 427;//Server Location
  IdPORT_ocs_cmu        = 428;//OCS_CMU
  IdPORT_ocs_amu        = 429;//OCS_AMU
  IdPORT_utmpsd         = 430;//UTMPSD
  IdPORT_utmpcd         = 431;//UTMPCD
  IdPORT_iasd           = 432;//IASD
  IdPORT_nnsp           = 433;//NNSP
  IdPORT_mobileip_agent = 434;//MobileIP-Agent
  IdPORT_mobilip_mn     = 435;//MobilIP-MN
  IdPORT_dna_cml        = 436;//DNA-CML
  IdPORT_comscm         = 437;//comscm
  IdPORT_dsfgw          = 438;//dsfgw
  IdPORT_dasp           = 439;//dasp      Thomas Obermair
  IdPORT_sgcp           = 440;//sgcp
  IdPORT_decvms_sysmgt  = 441;//decvms-sysmgt
  IdPORT_cvc_hostd      = 442;//cvc_hostd
  IdPORT_SSL     = 443;
  IdPORT_npp2    = 444;//Simple Network Paging Protocol [RFC1568]
  IdPORT_microsoft_ds = 445;//Microsoft-DS
  IdPORT_ddm_rdb = 446; //DDM-RDB
  IdPORT_ddm_dfm = 447;//DDM-RFM
  IdPORT_ddm_byte = 448;//DDM-BYTE
  IdPORT_as_servermap = 449;//AS Server Mapper
  IdPORT_tserver      = 450;//TServer
  IdPORT_sfs_smp_net  = 451;//Cray Network Semaphore server
  IdPORT_sfs_config = 452;//Cray SFS config server
  IdPORT_creativeserver = 453;//CreativeServer
  IdPORT_contentserver  = 454;//ContentServer
  IdPORT_creativepartnr = 455;//CreativePartnr
  IdPORT_macon_tcp      = 456;//macon-tcp
  IdPORT_scohelp        = 457;//scohelp
  IdPORT_appleqtc       = 458;//apple quick time
  IdPORT_ampr_rcmd      = 459;//ampr-rcmd
  IdPORT_skronk         = 460;//skronk
  IdPORT_datasurfsrv    = 461;//DataRampSrv
  IdPORT_datasurfsrvsec = 462;//DataRampSrvSec
  IdPORT_alpes          = 463;//alpes
  IdPORT_kpasswd        = 464;//kpasswd
  IdPORT_ssmtp          = 465;//ssmtp
  IdPORT_digital_vrc    = 466;//digital-vrc
  IdPORT_mylex_mapd     = 467;//mylex-mapd
  IdPORT_photuris       = 468;//proturis
  IdPORT_rcp            = 469;//Radio Control Protocol
  IdPORT_scx_proxy      = 470;//scx-proxy
  IdPORT_mondex         = 471;//Mondex
  IdPORT_ljk_login      = 472;//jk-login
  IdPORT_hybrid_pop     = 473;//hybrid-pop
  IdPORT_tn_tl_w1       = 474;//tcp    tn-tl-w1
  IdPORT_tn_tl_w2       = 474;//udp    tn-tl-w2
  IdPORT_tcpnethaspsrv  = 475;//tcp    tcpnethaspsrv
  IdPORT_tn_tl_fd1      = 476;//tn-tl-fd1
  IdPORT_ss7ns          = 477;//ss7ns
  IdPORT_spsc           = 478;//spsc
  IdPORT_iafserver      = 479;//iafserver
  IdPORT_iafdbase       = 480;//iafdbase
  IdPORT_ph             = 481;//Ph service
  IdPORT_bgs_nsi        = 482;//bgs-nsi
  IdPORT_ulpnet         = 483;//ulpnet
  IdPORT_integra_sme    = 484;//Integra Software Management Environment
  IdPORT_powerburst     = 485;//Air Soft Power Burst
  IdPORT_avian          = 486;//avian
  IdPORT_saft           = 487;//saft
  IdPORT_gss_http       = 488;//gss-http
  IdPORT_nest_protocol  = 489;//nest-protocol
  IdPORT_micom_pfs      = 490;//micom-pfs
  IdPORT_go_login       = 491;//go-login
  IdPORT_ticf_1         = 492;//Transport Independent Convergence for FNA
  IdPORT_ticf_2         = 493;//Transport Independent Convergence for FNA
  IdPORT_pov_ray        = 494;//tcp    POV-Ray
  IdPORT_intecourier    = 495; //tcp/udp  intecourier
  Id_PORT_pim_rp_disc = 496; //tcp/udp pim-rp-disc
  Id_PORT_dantz  = 497; //tcp/udp dantz
  Id_PORT_siam   = 498; //tcp/udp siam
  Id_PORT_ISO_ILL = 499; //tcp/udp iso-ill  ISO ILL Protocol
  Id_PORT_isakmp = 500; //tcp/udp isakmp
  Id_PORT_stmf   = 501; //tcp/udp stmf
  Id_PORT_asa_appl_proto = 502; //tcp/udp asa-appl-proto
  Id_PORT_intrinsa = 503; // intrinsa
  Id_PORT_citadel = 504; //citadel
  Id_PORT_mailbox_lm = 505; //mailbox-lm
  Id_PORT_ohimsrv = 506; //ohimsrv
  Id_PORT_crs = 507; //crs
  Id_PORT_xvttp = 508; //xvttp
  Id_PORT_snare = 509; //snare
  Id_PORT_FirstClass   = 510; //FirstClass Protocol
  Id_PORT_passgo = 511; //PassGo
  Id_PORT_exec   = 512; {/tcp    remote process execution;
                          authentication performed using
                          passwords and UNIX loppgin names      }

  Id_PORT_biff   = 512;{udp    used by mail system to notify users
                          of new mail received; currently
                          receives messages only from
                          processes on the same machine }
  Id_PORT_login  = 513;{tcp    remote login a la telnet;
                          automatic authentication performed
                          based on priviledged port numbers
                          and distributed data bases which
                          identify "authentication domains"   }
  IdPORT_who     = 513;{udp    maintains data bases showing who's
                          logged in to machines on a local
                          net and the load average of the
                          machine }
  IdPORT_cmd     = 514;{tcp    like exec, but automatic
                           authentication is performed as for
                           login server }
  IdPORT_syslog  = 514;{udp }
  IdPORT_LPD     = 515;
  IdPORT_talk    = 517;{tcp    like tenex link, but across
                          machine - unfortunately, doesn't
                          use link protocol (this is actually
                          just a rendezvous port from which a
                          tcp connection is established)}
  IdPORT_ntalk   = 518;
  IdPORT_utime   = 519; //    unixtime
  IdPORT_efs     = 520; //tcp    extended file name server
  IdPORT_router  = 520; {udp    local routing process (on site);
                          uses variant of Xerox NS routing
                          information protocol    }
  IdPORT_timed   = 525; // timeserver
  IdPORT_tempo   = 526; // newdate
  IdPORT_courier = 530; // rpc
  IdPORT_conference = 531;//chat
  IdPORT_netnews    = 532;//readnews
  IdPORT_netwall    = 533;// for emergency broadcasts

  IdPORT_apertus_ldp = 539;// Apertus Technologies Load Determination
  IdPORT_uucp       = 540;// uucpd
  IdPORT_uucp_rlogin = 541;//uucp-rlogin
  IdPORT_klogin      = 543;//
  IdPORT_kshell      = 544;//krcmd
  IdPORT_appleqtcsrvr = 545; // appleqtcsrvr
  IdPORT_dhcp_client_v6  = 546; //DHCP Client   IP 6
  IdPORT_dhcp_server_v6  = 547; // DHCP Server  IP 6
  Id_PORT_afpovertcp    = 548;//tcp    AFP over TCP
  Id_PORT_idfp          = 549;//tcp    IDFP
  IdPORT_new_rwho     = 550; // new-who
  IdPORT_cybercash    = 551; // cybercash
  IdPORT_deviceshare  = 552; // deviceshare
  IdPORT_pirp         = 553; //  pirp
  IdPORT_rtsp         = 554; //  Real Time Stream Control Protocol
  IdPORT_dsf          = 555;
  IdPORT_remotefs     = 556; //rfs server
  IdPORT_openvms_sysipc = 557;// openvms-sysipc
  IdPORT_sdnskmp      = 558;// SDNSKMP
  IdPORT_teedtap      = 559;// TEEDTAP
  IdPORT_rmonitor     = 560;// rmonitord
  IdPORT_monitor      = 561;//
  IdPORT_chshell      = 562;// chcmd
  IdPORT_SNEWS        = 563;
  IdPORT_9pfs         = 564;/// plan 9 file service
  IdPORT_whoami       = 565;// whoami
  IdPORT_streettalk   = 566;// streettalk
  IdPORT_banyan_rpc   = 567;//banyan-rpc
  IdPORT_ms_shuttle   = 568;//microsoft shuttle
  IdPORT_ms_rome      = 569;//microsoft rome
  IdPORT_meter        = 570;//demon
  IdPORT_meter_udemon = 571;//udemon
  IdPORT_sonar        = 572;//sonar
  IdPORT_banyan_vip   = 573;//banyan-vip
  IdPORT_ftp_agent    = 574;//FTP Software Agent System
  IdPORT_vemmi        = 575;//VEMMI
  Id_PORT_ipcd        = 576;//tcp    ipcd
  Id_PORT_vnas        = 577;//tcp    vnas
  Id_PORT_ipdd        = 578;//tcp    ipdd
  Id_PORT_decbsrv     = 579;//tcp    decbsrv
  Id_PORT_sntp_heartbeat = 580;//tcp    SNTP HEARTBEAT
  Id_PORT_bdp	      = 581;//tcp    Bundle Discovery Protocol
  Id_PORT_scc_security = 582;//tcp    SCC Security
  Id_PORT_philips_vc  =	583;//tcp    Philips Video-Conferencing
  Id_PORT_keyserver   = 584;//tcp    Key Server
  Id_PORT_imap4_ssl_dp = 585;//tcp    IMAP4+SSL (use 993 instead)
//               Use of 585 is not recommended, use 993 instead
  Id_PORT_password_chg = 586;//tcp    Password Change
  Id_PORT_submission   = 587;//tcp    Submission
  Id_PORT_cal	       = 588;//tcp    CAL
  Id_PORT_eyelink      = 589;//tcp    EyeLink
  Id_PORT_tns_cml      = 590;//tcp    TNS CML
  Id_PORT_http_alt     = 591;//tcp    FileMaker, Inc. - HTTP Alternate (see Port 80)
  Id_PORT_eudora_set   = 592;//tcp    Eudora Set
  Id_PORT_http_rpc_epmap = 593;//tcp    HTTP RPC Ep Map
  Id_PORT_tpip	       = 594;//tcp    TPIP
  Id_PORT_cab_protocol = 595;//tcp    CAB Protocol
  Id_PORT_smsd	       = 596;//tcp    SMSD
  Id_PORT_ptcnameservice = 597;//tcp    PTC Name Service
  Id_PORT_sco_websrvrmg3 = 598;//tcp    SCO Web Server Manager 3
  Id_PORT_acp         = 599;//tcp    Aeolon Core Protocol
  IdPORT_ipcserver    = 600;//Sun IPC server
  Id_PORT_syslog_conn  = 601;//Reliable Syslog protocol

  IdPORT_urm          = 606;//Cray Unified Resource Manager
  IdPORT_nqs          = 607;//nqs
  IdPORT_sift_uft     = 608;//Sender-Initiated/Unsolicited File Transfer
  IdPORT_npmp_trap    = 609;//npmp-trap
  IdPORT_npmp_local   = 610;//npmp-local
  IdPORT_npmp_gui     = 611;//npmp-gui
  Id_PORT_hmmp_ind    = 612;//tcp    HMMP Indication
  Id_PORT_hmmp_op     = 613;//tcp    HMMP Operation
  Id_PORT_sshell      = 614;//tcp    SSLshell
  Id_PORT_sco_inetmgr =	615;//tcp    Internet Configuration Manager
  Id_PORT_sco_sysmgr  = 616;//tcp    SCO System Administration Server
  Id_PORT_sco_dtmgr   =	617;//tcp    SCO Desktop Administration Server
  Id_PORT_dei_icda    = 618;//tcp    DEI-ICDA
  Id_PORT_compaq_evm  = 619;//tcp    Compaq EVM
  Id_PORT_sco_websrvrmgr = 620;//tcp    SCO WebServer Manager
  Id_PORT_escp_ip     = 621;//tcp    ESCP
  Id_PORT_collaborator = 622;//tcp    Collaborator
  Id_PORT_aux_bus_shunt	= 623;//tcp    Aux Bus Shunt
  Id_PORT_cryptoadmin  = 624;//tcp    Crypto Admin
  Id_PORT_dec_dlm     = 625;//tcp    DEC DLM
  Id_PORT_asia	      =	626;//tcp    ASIA
  Id_PORT_passgo_tivoli	= 627;//tcp    PassGo Tivoli
  Id_PORT_qmqp	      = 628;//tcp    QMQP
  Id_PORT_3com_amp3   = 629;//tcp    3Com AMP3
  Id_PORT_rda	      = 630;//tcp    RDA
  Id_PORT_ipp	      = 631;//tcp    IPP (Internet Printing Protocol)
  Id_PORT_bmpp	      = 632;//tcp    bmpp
  IdPORT_servstat     = 633;// Service Status update (Sterling Software)
  IdPORT_ginad        = 634;// ginad
  Id_PORT_rlzdbase    = 635;//tcp    RLZ DBase
  Id_PORT_ldaps       = 636;//tcp    ldap protocol over TLS/SSL (was sldap)
  Id_PORT_lanserver   = 637;//tcp    lanserver
  Id_PORT_mcns_sec    = 638;//tcp    mcns-sec
  Id_PORT_msdp	      =	639;//tcp    MSDP
  Id_PORT_entrust_sps = 640;//tcp    entrust-sps
  Id_PORT_repcmd      = 641;//tcp    repcmd
  Id_PORT_esro_emsdp  =	642;//tcp    ESRO-EMSDP V1.3
  Id_PORT_sanity      = 643;//tcp    SANity
  Id_PORT_dwr	      = 644;//tcp    dwr
  Id_PORT_pssc	      =	645;//tcp    PSSC
  Id_PORT_ldp	      =	646;//tcp    LDP
  Id_PORT_dhcp_failover = 647;//tcp    DHCP Failover
  Id_PORT_rrp	      =	648;//tcp    Registry Registrar Protocol (RRP)
  Id_PORT_aminet      =	649;//tcp    Aminet
  Id_PORT_obex	      =	650;//tcp    OBEX
  Id_PORT_ieee_mms    =	651;//tcp    IEEE MMS
  Id_PORT_hello_port  = 652;//tcp    HELLO_PORT
  Id_PORT_repscmd     =	653;//tcp    RepCmd
  Id_PORT_aodv	      =	654;//tcp	   AODV
  Id_PORT_tinc	      =	655;//tcp    TINC
  Id_PORT_spmp	      =	656;//tcp    SPMP
  Id_PORT_rmc	      =	657;//tcp    RMC
  Id_PORT_tenfold     = 658;//tcp    TenFold

  Id_PORT_mac_srvr_admin = 660;//tcp    MacOS Server Admin
  Id_PORT_hap	      =	661;//tcp    HAP
  Id_PORT_pftp	      = 662;//tcp    PFTP
  Id_PORT_purenoise   = 663;//tcp    PureNoise
  Id_PORT_secure_aux_bus = 664;//tcp    Secure Aux Bus
  Id_PORT_sun_dr      = 665;//tcp    Sun DR
  IdPORT_mdqs         = 666;//
  IdPORT_doom         = 666;//doom Id Software
  Id_PORT_disclose    = 667;//campaign contribution disclosures - SDR Technologies
  Id_PORT_mecomm      = 668;//MeComm
  Id_PORT_meregister  = 669;//MeRegister
  Id_PORT_vacdsm_sws  = 670;//VACDSM-SWS
  Id_PORT_vacdsm_app  = 671;//VACDSM-APP
  Id_PORT_vpps_qua    = 672; //VPPS-QUA
  Id_PORT_cimplex     = 673; //CIMPLEX
  Id_PORT_acap        = 674; //ACAP
  Id_PORT_dctp        = 675; //DCTP
  Id_PORT_vpps_via    = 676; //VPPS Via
  Id_PORT_vpp         = 677; //Virtual Presence Protocol
  Id_PORT_gnf_ncp     = 678;//GNU Generation Foundation NCP
  Id_PORT_mrm         = 679;//MRM
  Id_PORT_entrust_aaas = 680;//entrust-aaas
  Id_PORT_entrust_aams = 681;//entrust-aams
  Id_PORT_xfr          = 682;//XFR
  Id_PORT_corba_iiop   = 683;//CORBA IIOP
  Id_PORT_corba_iiop_ssl = 684; //CORBA IIOP SSL
  Id_PORT_mdc_portmapper = 685; //MDC Port Mapper
  Id_PORT_hcp_wismar  = 686; //Hardware Control Protocol Wismar
  Id_PORT_asipregistry = 687;//asipregistry
  Id_PORT_realm_rusd     = 688; //REALM-RUSD
  Id_PORT_nmap        = 689;//NMAP
  Id_PORT_vatp        = 690; //VATP
  Id_PORT_msexch_routing = 691; //msexch-routing
  Id_PORT_hyperwave_isp = 692; //Hyperwave-ISP
  Id_PORT_connendp    = 693; //connendp
  Id_PORT_ha_cluster  = 694; //ha-cluster
  Id_PORT_ieee_mms_ssl = 695; //IEEE-MMS-SSL
  Id_PORT_rushd = 696; //RUSHD
  Id_PORT_uuidgen = 697; //UUIDGEN
  Id_PORT_olsr        = 698; //OLSR
  Id_PORT_accessnetwork = 699; //Access Network

  IdPORT_elcsd        = 704;//errlog copy/server daemon
  Id_PORT_agentx      = 705; //AgentX
  Id_PORT_silc        = 706; //SILC
  Id_PORT_borland_dsj = 707; // Borland DSJ

  IdPORT_entrustmanager = 709;//EntrustManager
  Id_PORT_entrust_ash   = 710;// Entrust Administration Service Handler
  Id_PORT_cisco_tdp     = 711; //Cisco TDP

  IdPORT_netviewdm1     = 729;//IBM NetView DM/6000 Server/Client
  IdPORT_netviewdm2     = 730;//IBM NetView DM/6000 send/tcp
  IdPORT_netviewdm3     = 731;//IBM NetView DM/6000 receive/tcp
  IdPORT_netgw          = 741;//netGW
  IdPORT_netrcs         = 742;//Network based Rev. Cont. Sys.

  IdPORT_flexlm         = 744;//Flexible License Manager

  IdPORT_fujitsu_dev    = 747;//Fujitsu Device Control
  IdPORT_ris_cm         = 748;//Russell Info Sci Calendar Manager
  IdPORT_kerberos_adm   = 749;//kerberos administration
  IdPORT_rfile          = 750;//tcp
  IdPORT_loadav         = 750;//udp
  IdPORT_pump           = 751;
  IdPORT_qrh            = 752;
  IdPORT_rrh            = 753;
  IdPORT_tell           = 754;// send
  IdPORT_nlogin         = 758;
  IdPORT_con            = 759;
  IdPORT_ns             = 760;
  IdPORT_rxe            = 761;
  IdPORT_quotad         = 762;
  IdPORT_cycleserv      = 763;
  IdPORT_omserv         = 764;
  IdPORT_webster        = 765;
  IdPORT_phonebook      = 767;// phone
  IdPORT_vid            = 769;
  IdPORT_cadlock        = 770;
  IdPORT_rtip   = 771;
  IdPORT_cycleserv2 = 772;
  IdPORT_submit = 773;//tcp
  IdPORT_notify = 773;//udp
  IdPORT_rpasswd = 774;//tcp
  IdPORT_acmaint_dbd = 774; //udp
  IdPORT_entomb = 775;
  IdPORT_acmaint_transd = 775;
  IdPORT_wpages = 776;
  IdPORT_wpgs   = 780;

  IdPORT_concert = 786;//Concert
  IdPORT_qsc   = 787; //QSC

  IdPORT_mdbs_daemon = 800;

  IdPORT_device = 801;

  Id_PORT_fcp = 810; //FCP or FCP datagram (udp)

  Id_PORT_itm_mcell_s = 828; //itm-mcell-s
  Id_PORT_pkix_3_ca_ra  = 829; //PKIX-3 CA/RA


  Id_PORT_dhcp_failover2 = 847;  //dhcp-failover 2

  Id_PORT_rsync	= 873; //rsync
  Id_PORT_iclcnet_locate = 886; //ICL coNETion locate server
  Id_PORT_iclcnet_svinfo = 887; //ICL coNETion server info
  IdPORT_accessbuilder = 888;//udp        AccessBuilder

  Id_PORT_omginitialrefs = 900;//omginitialrefs
  Id_PORT_smpnameres  = 901; //smpnameres
  Id_PORT_ideafarm_chat = 902;  //IDEAFARM CHAT
  Id_PORT_ideafarm_catch = 903; //IDEAFARM CATCH

  IdPOPRT_xact_backup = 911;//xact-backup
  IdPORT_ftps_data = 989; //ftp protocol, data, over TLS/SSL
  IdPORT_ftps   = 990; //ftp protocol, control, over TLS/SSL
  IdPORT_nas    = 991; //Netnews Administration System
  IdPORT_TelnetS = 992; //telnet protocol over TLS/SSL
  IdPORT_IMAP4S = 993; //imap4 protocol over TLS/SSL
  IdPORT_IRCS  = 994; // irc protocol over TLS/SSL
  IdPORT_POP3S = 995; // POP3 protocol over TLS/SSL
  IdPORT_vsinet = 996;//tcp    vsinet
  IdPORT_maitrd = 997; //tcp
  IdPORT_busboy = 998;//tcp
  IdPORT_puparp = 998;//udp
  {There are port conflicts - beware}
  IdPORT_garcon = 999;//tcp
  IdPORT_applix = 999;//udp       Applix ac
  IdPORT_puprouter = 999;//tcp
  IdPORT_cadlock2 = 1000;//tcp
  IdPORT_ock = 1000;  //udp

  ID_PORT_surf = 1010; //surf

  {These were added simply for compatibility and were not listed in RFC 1700}
  IdPORT_SOCKS   = 1080;
  IdPORT_DICT    = 2628;
  IdPORT_IRC     = 6667;

const

  Id_AIVN_Rserved = 0;//                Reserved                                [JBP]
  Id_AIVN_IP = 4; //       IP       Internet Protocol                [RFC791,JBP]
  Id_AIVN_ST = 5; //       ST       ST Datagram Mode                [RFC1190,JWF]
  Id_AIVN_SIP = 6; //       SIP      Simple Internet Protocol                [RH6]
  Id_AIVN_TP_IX = 7; //       TP/IX    TP/IX: The Next Internet                [RXU]
  Id_AIVN_PIP = 8; //       PIP      The P Internet Protocol                 [PXF]
  Id_AIVN_Tuba = 9; //       TUBA     TUBA                                    [RXC]
  Id_AIVN_Reserved2 = 15; //                Reserved


const
  {Assigned Internet Protocol Numbers from RFC 1700}
  Id_AIPN_Reserved = 0;
  Id_AIPN_ICMP = 1; //     ICMP        Internet Control Message       [RFC792,JBP]
  Id_AIPN_IGMP = 2; //     IGMP        Internet Group Management     [RFC1112,JBP]
  Id_AIPN_GGP  = 3; //     GGP         Gateway-to-Gateway              [RFC823,MB]
  Id_AIPN_IP   = 4; //     IP          IP in IP (encasulation)               [JBP]
  Id_AIPN_ST   = 5; //     ST          Stream                 [RFC1190,IEN119,JWF]
  Id_AIPN_TCP  = 6; //     TCP         Transmission Control           [RFC793,JBP]
  Id_AIPN_UCL  = 7; //     UCL         UCL                                    [PK]
  Id_AIPN_EGP  = 8; //     EGP         Exterior Gateway Protocol     [RFC888,DLM1]
  Id_AIPN_IGP  = 9; //     IGP         any private interior gateway          [JBP]
  Id_AIPN_BBN_RCC_MON = 10; //     BBN-RCC-MON BBN RCC Monitoring                    [SGC]
  Id_AIPN_NVP_II = 11; //     NVP-II      Network Voice Protocol         [RFC741,SC3]
  Id_AIPN_PUP    = 12; //     PUP         PUP                             [PUP,XEROX]
  Id_AIPN_ARGUS  = 13; //     ARGUS       ARGUS                                [RWS4]
  Id_AIPN_EMCON  = 14; //    EMCON       EMCON                                 [BN7]
  Id_AIPN_XNET   = 15; //     XNET        Cross Net Debugger            [IEN158,JFH2]
  Id_AIPN_CHAOS  = 16; //     CHAOS       Chaos                                 [NC3]
  Id_AIPN_UDP    = 17; //     UDP         User Datagram                  [RFC768,JBP]
  Id_AIPN_MUX    = 18; //     MUX         Multiplexing                    [IEN90,JBP]
  Id_AIPN_DCN_MEAS = 19; //    DCN-MEAS    DCN Measurement Subsystems           [DLM1]
  Id_AIPN_HMP      = 20; //     HMP         Host Monitoring                [RFC869,RH6]
  Id_AIPN_PRM      = 21; //     PRM         Packet Radio Measurement              [ZSU]
  Id_AIPN_XNS_IDP = 22; //     XNS-IDP     XEROX NS IDP               [ETHERNET,XEROX]
  Id_AIPN_TRUNK_1 = 23; //     TRUNK-1     Trunk-1                              [BWB6]
  Id_AIPN_TRUNK_2 = 24; //     TRUNK-2     Trunk-2                              [BWB6]
  Id_AIPN_LEAF_1  = 25; //     LEAF-1      Leaf-1                               [BWB6]
  Id_AIPN_LEAF_2  = 26; //     LEAF-2      Leaf-2                               [BWB6]
  Id_AIPN_RDP     = 27; //     RDP         Reliable Data Protocol         [RFC908,RH6]
  Id_AIPN_IRTP    = 28; //     IRTP        Internet Reliable Transaction  [RFC938,TXM]
  Id_AIPN_ISO_TP4 = 29; //     ISO-TP4     ISO Transport Protocol Class 4 [RFC905,RC77]
  Id_AIPN_NETBLT  = 30; //     NETBLT      Bulk Data Transfer Protocol    [RFC969,DDC1]
  Id_AIPN_NFE_NSP = 31; //     MFE-NSP     MFE Network Services Protocol  [MFENET,BCH2]
  Id_AIPN_MERIT_IMP = 32; //     MERIT-INP   MERIT Internodal Protocol             [HWB]
  Id_AIPN_SEP       = 33; //     SEP         Sequential Exchange Protocol        [JC120]
  Id_AIPN_3PC       = 34; //     3PC         Third Party Connect Protocol         [SAF3]
  Id_AIPN_IDPR      = 35; //     IDPR        Inter-Domain Policy Routing Protocol [MXS1]
  Id_AIPN_XTP       = 36; //     XTP         XTP                                   [GXC]
  Id_AIPN_DDP       = 37; //     DDP         Datagram Delivery Protocol            [WXC]
  Id_AIPN_IDPR_CMTP      = 38; //     IDPR-CMTP   IDPR Control Message Transport Proto [MXS1]
  Id_AIPN_TP_PLUS_PLUS   = 39; //     TP++        TP++ Transport Protocol               [DXF]
  Id_AIPN_IL        =  40; //     IL          IL Transport Protocol                [DXP2]
  Id_AIPN_SIP       =  41; //     SIP         Simple Internet Protocol              [SXD]
  Id_AIPN_SDRP      =  42; //     SDRP        Source Demand Routing Protocol       [DXE1]
  Id_AIPN_SIP_SR    =  43; //     SIP-SR      SIP Source Route                      [SXD]
  Id_AIPN_SIP_FRAG  =  44; //     SIP-FRAG    SIP Fragment                          [SXD]
  Id_AIPN_IDRP =  45; //     IDRP        Inter-Domain Routing Protocol   [Sue Hares]
  Id_AIPN_RSVP =  46; //    RSVP        Reservation Protocol           [Bob Braden]
  Id_AIPN_GRE  =  47; //     GRE         General Routing Encapsulation     [Tony Li]
  Id_AIPN_MHRP =  48; //     MHRP        Mobile Host Routing Protocol[David Johnson]
  Id_AIPN_BNA  =  49; //     BNA         BNA                          [Gary Salamon]
  Id_AIPN_SIPP_ESB = 50; //     SIPP-ESP    SIPP Encap Security Payload [Steve Deering]
  Id_AIPN_SIPP_AH  = 51; //     SIPP-AH     SIPP Authentication Header  [Steve Deering]
  Id_AIPN_I_NLSP   = 52; //     I-NLSP      Integrated Net Layer Security  TUBA [GLENN]
  Id_AIPN_SWIPE = 53; //     SWIPE       IP with Encryption                    [JI6]
  Id_AIPN_NHRP  = 54; //     NHRP        NBMA Next Hop Resolution Protocol
  Id_AIPN_MOBILE = 55;//     MOBILE      IP Mobility                       [Perkins]
  Id_AIPN_TLSP = 56;//     TLSP        Transport Layer Security Protocol   [Oberg]
  Id_AIPN_Kryptonet = 58;//             using Kryptonet key management
  Id_AIPN_SKIP = 57;//     SKIP        SKIP                              [Markson]
  Id_AIPN_IPV6_ICMP = 58;//     IPv6-ICMP   ICMP for IPv6                     [RFC1883]
  Id_AIPN_IPV6_NO_NEXT = 59;//     IPv6-NoNxt  No Next Header for IPv6           [RFC1883]
  Id_AIPN_IPV6_OPTS = 60;//     IPv6-Opts   Destination Options for IPv6      [RFC1883]
  Id_AIPN_Any_Host_Internal = 61; // any host internal protocol            [JBP]
  Id_AIPN_CFTP  = 62; //     CFTP        CFTP                            [CFTP,HCF2]
  Id_AIPN_Any_LAN = 63; //                 any local network                     [JBP]
  Id_AIPN_SAT_EXPACK = 64; //     SAT-EXPAK   SATNET and Backroom EXPAK             [SHB]
  Id_AIPN_KRYPTOLAN = 65; //    KRYPTOLAN   Kryptolan                            [PXL1]
  Id_AIPN_RVD = 66; //     RVD         MIT Remote Virtual Disk Protocol      [MBG]
  Id_AIPN_IPPC = 67; //     IPPC        Internet Pluribus Packet Core         [SHB]
  Id_AIPN_Any_Distributed_File_System = 68; //any distributed file system           [JBP]
  Id_AIPN_SAT_MON = 69; //     SAT-MON     SATNET Monitoring                     [SHB]
  Id_AIPN_VISA = 70;//     VISA        VISA Protocol                        [GXT1]
  Id_AIPN_IPCV = 71;//     IPCV        Internet Packet Core Utility          [SHB]
  Id_AIPN_CPNX = 72; //     CPNX        Computer Protocol Network Executive  [DXM2]
  Id_AIPN_CPHB = 73; //     CPHB        Computer Protocol Heart Beat         [DXM2]
  Id_AIPN_WSM  = 74; //    WSN         Wang Span Network                     [VXD]
  Id_AIPN_PVP  = 75; //     PVP         Packet Video Protocol                 [SC3]
  Id_AIPN_BR_SAT_MON = 76; //     BR-SAT-MON  Backroom SATNET Monitoring            [SHB]
  Id_AIPN_SUN_ND  = 77; //     SUN-ND      SUN ND PROTOCOL-Temporary             [WM3]
  Id_AIPN_WB_MON  = 78; //     WB-MON      WIDEBAND Monitoring                   [SHB]
  Id_AIPN_EXPAK   = 79; //     WB-EXPAK    WIDEBAND EXPAK                        [SHB]
  Id_AIPN_ISO_IP  = 80; //     ISO-IP      ISO Internet Protocol                 [MTR]
  Id_AIPN_VMTP    = 81; //     VMTP        VMTP                                 [DRC3]
  Id_AIPN_SECURE_VMTP = 82; //     SECURE-VMTP SECURE-VMTP                          [DRC3]
  Id_AIPN_VINES = 83; //     VINES       VINES                                 [BXH]
  Id_AIPN_TTP =  84;//     TTP         TTP                                   [JXS]
  Id_AIPN_NSFNET_IGP = 85;//     NSFNET-IGP  NSFNET-IGP                            [HWB]
  Id_AIPN_DGP = 86;//     DGP         Dissimilar Gateway Protocol     [DGP,ML109]
  Id_AIPN_TCF = 87; //     TCF         TCF                                  [GAL5]
  Id_AIPN_IGRP = 88;//     IGRP        IGRP                            [CISCO,GXS]
  Id_AIPN_OSPFIGP = 89;//     OSPFIGP     OSPFIGP                      [RFC1583,JTM4]
  Id_AIPN_Sprite_RPC = 90; //     Sprite-RPC  Sprite RPC Protocol            [SPRITE,BXW]
  Id_AIPN_LARP = 91; //     LARP        Locus Address Resolution Protocol     [BXH]
  Id_AIPN_MTP = 92;//     MTP         Multicast Transport Protocol          [SXA]
  Id_AIPN_AX_25 = 93;//     AX.25       AX.25 Frames                         [BK29]
  Id_AIPN_IPIP = 94;//     IPIP        IP-within-IP Encapsulation Protocol   [JI6]
  Id_AIPN_MICP =  95;//     MICP        Mobile Internetworking Control Pro.   [JI6]
  Id_AIPN_SCC_SP = 96;//     SCC-SP      Semaphore Communications Sec. Pro.    [HXH]
  Id_AIPN_ETHERIP = 97;//     ETHERIP     Ethernet-within-IP Encapsulation     [RXH1]
  Id_AIPN_ENCAP = 98; //    ENCAP       Encapsulation Header         [RFC1241,RXB3]
  Id_AIPN_Any_Private_Encryption =  99; //any private encryption scheme         [JBP]
  Id_AIPN_GMTP = 100;//     GMTP        GMTP                                 [RXB5]
  Id_AIPN_IFMP = 101;//     IFMP        Ipsilon Flow Management Protocol   [Hinden]
  Id_AIPN_PNNI = 102;//    PNNI        PNNI over IP                       [Callon]
  Id_AIPN_PIM  = 103;//    PIM         Protocol Independent Multicast  [Farinacci]
  Id_AIPN_ARIS = 104;//     ARIS        ARIS                              [Feldman]
  Id_AIPN_SCPS = 105;//  SCPS				   [Durst]
  Id_AIPN_QNX = 106;//  QNX	       QNX				  [Hunter]
  Id_AIPN_A_N = 107; //  A/N	      Active Networks                    [Braden]
  Id_AIPN_IPComp = 108;//  IPComp     IP Payload Compression Protocol   [RFC2393]
  Id_AIPN_SNP = 109;//   SNP    Sitara Networks Protocol          [Sridhar]
  Id_AIPN_Compaq_Peer = 110;//	 Compaq-Peer Compaq Peer Protocol                [Volpe]
  Id_AIPN_IPX_In_IP = 111;//  IPX-in-IP   IPX in IP		  	     [Lee]
  Id_AIPN_VRRP = 112; //VRRP    Virtual Router Redundancy Protocol [Hinden]
  Id_AIPN_PGM = 113; //PGM     PGM Reliable Transport Protocol  [Speakman]
  Id_AIPN_0_HOP = 114;// any 0-hop protocol                   [IANA]
  Id_AIPN_L2TP = 115;//  L2TP   Layer Two Tunneling Protocol        [Aboba]
  Id_AIPN_DDX = 116;//  DDX   D-II Data Exchange (DDX)           [Worley]
  Id_AIPN_IATP = 117;//  IATP   Interactive Agent Transfer Protocol  [Murphy]
  Id_AIPN_STP = 118;// STP   Schedule Transfer Protocol            [JMP]
  Id_AIPN_SRP = 119;// SRP   SpectraLink Radio Protocol       [Hamilton]
  Id_AIPN_UTI = 120;// UTI   [Lothberg]
  Id_AIPN_SMP = 121;//  SMP    Simple Message Protocol            [Ekblad]
  Id_AIPN_SM  = 122;// SM     SM			       [Crowcroft]
  Id_AIPN_PTP = 123;// PTP   Performance Transparency Protocol   [Welzl]
  Id_AIPN_ISIS = 124;//ISIS over IPv4			      [Przygienda]
  Id_AIPN_FIRE = 125;// FIRE          [Partridge]
  Id_AIPN_CRTP = 126;// CRTP 	Combat Radio Transport Protocol  [Sautter]
  Id_AIPN_CRUDP = 127; // CRUDP	Combat Radio User Datagram	 [Sautter]
  Id_AIPN_SSCOPMCE = 128;// SSCOPMCE  [Waber]
  Id_AIPN_IPLT = 129;//  IPLT  [Hollbach]
  Id_AIPN_SPS = 130;//  SPS   Secure Packet Shield             [McIntosh]
  Id_AIPN_PIPE = 131;//  PIPE   Private IP Encapsulation within IP       [Petri]
  Id_AIPN_SCTP = 132;//     SCTP   Stream Control Transmission Protocol   [Stewart]
  Id_AIPN_FC = 133;//  FC     Fibre Channel             [Rajagopal]
  Id_AIPN_RSVP_E2E_IGNORE = 134;//     RSVP-E2E-IGNORE                             [RFC3175]
  Id_AIPN_Reserved2 =  255;//                Reserved

  {Operating SYstem names}
  Id_OS_Aegis = 'AEGIS'; {Do not Localize}
  Id_OS_Amiga_1_2 ='AMIGA-OS-1.2'; {Do not Localize}
  Id_OS_Amiga_1_3 = 'AMIGA-OS-1.3'; {Do not Localize}
  Id_OS_Amiga_2_0 = 'AMIGA-OS-2.0'; {Do not Localize}
  Id_OS_Amiga_2_1 = 'AMIGA-OS-2.1'; {Do not Localize}
  Id_OS_Amiga_3_0 = 'AMIGA-OS-3.0'; {Do not Localize}
  Id_OS_Amiga_3_1 = 'AMIGA-OS-3.1'; {Do not Localize}
  Id_OS_Amiga_3_5 = 'AMIGA-OS-3.5'; {Do not Localize}
  Id_OS_Amiga_3_9 = 'AMIGA-OS-3.9'; {Do not Localize}
  Id_OS_Apollo = 'APOLLO';          {Do not Localize}
  Id_OS_AIX_370 = 'AIX/370';        {Do not Localize}
  Id_OS_AIX_PS2 = 'AIX-PS/2';       {Do not Localize}
  Id_OS_BEOS_4_5_2 = 'BEOS-4.5.2';  {Do not Localize}
  Id_OS_BEOS_5_0 ='BEOS-5.0';       {Do not Localize}
  Id_OS_BS_2000 = 'BS-2000';        {Do not Localize}
  Id_OS_Cedar   = 'CEDAR';          {Do not Localize}
  Id_OS_CGW = 'CGW';                {Do not Localize}
  Id_OS_CHORUS = 'CHORUS';          {Do not Localize}
  Id_OS_Chrysalis = 'CHRYSALIS';    {Do not Localize}
  Id_OS_CMOS = 'CMOS';              {Do not Localize}
  Id_OS_CMS ='CMS';                 {Do not Localize}
  Id_OS_COS = 'COS';                {Do not Localize}
  Id_OS_CPIX = 'CPIX';              {Do not Localize}
  Id_OS_CTOS = 'CTOS';              {Do not Localize}
  Id_OS_CTSS = 'CTSS';              {Do not Localize}
  Id_OS_DCN  = 'DCN';               {Do not Localize}
  Id_OS_DDNOS = 'DDNOS';            {Do not Localize}
  Id_OS_DOMAIN = 'DOMAIN';          {Do not Localize}
  Id_OS_DOS = 'DOS';                {Do not Localize}
  Id_OS_EDX = 'EDX';                {Do not Localize}
  Id_OS_ELF = 'ELF';                {Do not Localize}
  Id_OS_EMBOS = 'EMBOS';            {Do not Localize}
  Id_OS_EMMOS = 'EMMOS';            {Do not Localize}
  Id_OS_EPOS  = 'EPOS';             {Do not Localize}
  Id_OS_FOONEX = 'FOONEX';          {Do not Localize}
  Id_OS_FORTH = 'FORTH';            {Do not Localize}
  Id_OS_FUZZ = 'FUZZ';              {Do not Localize}
  Id_OS_GCOS = 'GCOS';              {Do not Localize}
  Id_OS_GPOS = 'GPOS';              {Do not Localize}
  Id_OS_HDOS = 'HDOS';              {Do not Localize}
  Id_OS_Imagen = 'IMAGEN';          {Do not Localize}
  Id_OS_Instant_Internet = 'INSTANT-INTERNET'; {Do not Localize}
  Id_OS_Intercom = 'INTERCOM';      {Do not Localize}
  Id_OS_Impress = 'IMPRESS';        {Do not Localize}
  Id_OS_Interlisp = 'INTERLISP';    {Do not Localize}
  Id_OS_IOS       = 'IOS';          {Do not Localize}
  Id_OS_IRIX      = 'IRIX';         {Do not Localize}
  Id_OS_ISI       = 'ISI-68020';    {Do not Localize}
  Id_OS_ITS       = 'ITS';          {Do not Localize}
  Id_OS_KOSOS     = 'KOSOS';        {Do not Localize}
  Id_OS_Linux     = 'LINUX';        {Do not Localize}
  Id_OS_Linux_1_0 = 'LINUX-1.0';    {Do not Localize}
  Id_OS_Linux_1_2 = 'LINUX-1.2';    {Do not Localize}
  Id_OS_Linux_2_0 = 'LINUX-2.0';    {Do not Localize}
  Id_OS_Linux_2_2 = 'LINUX-2.2';    {Do not Localize}

  Id_OS_LISP      = 'LISP';         {Do not Localize}
  Id_OS_LISPM     = 'LISPM';        {Do not Localize}
  Id_OS_LOCUS     = 'LOCUS';        {Do not Localize}
  Id_OS_MACOS     = 'MACOS';        {Do not Localize}
  Id_OS_MINOS     = 'MINOS';        {Do not Localize}
  Id_OS_MOS = 'MOS';                {Do not Localize}
  Id_OS_MPE5 = 'MPE5';              {Do not Localize}
  Id_OS_MPEV = 'MPE/V';             {Do not Localize}
  Id_OS_MPEIX = 'MPE/IX';           {Do not Localize}
  Id_OS_MSDOS = 'MSDOS';            {Do not Localize}
  Id_OS_MULTICS = 'MULTICS';        {Do not Localize}
  Id_OS_MUSIC = 'MUSIC';            {Do not Localize}
  Id_OS_MUSICSP = 'MUSIC/SP';       {Do not Localize}
  Id_OS_MVS = 'MVS';                {Do not Localize}
  Id_OS_MVSSP = 'MVS/SP';           {Do not Localize}
  Id_NET_BSD_1_0 = 'NETBSD-1.0';    {Do not Localize}
  Id_NET_BSD_1_1 = 'NETBSD-1.1';    {Do not Localize}
  Id_NET_BSD_1_2 = 'NETBSD-1.2';    {Do not Localize}
  Id_NET_BSD_1_3 = 'NETBSD-1.3';    {Do not Localize}
  Id_NET_BSD_3_0 = 'NETWARE-3';     {Do not Localize}
  Id_NET_BSD_3_11 = 'NETWARE-3.11'; {Do not Localize}
  Id_NET_BSD_4_0 = 'NETWARE-4.0';   {Do not Localize}
  Id_NET_BSD_4_1 = 'NETWARE-4.1';   {Do not Localize}
  Id_NET_BSD_5_0 = 'NETWARE-5.0';   {Do not Localize}

  Id_OS_NEXUS = 'NEXUS';            {Do not Localize}
  Id_OS_NMS = 'NMS';                {Do not Localize}
  Id_OS_NONSTOP = 'NONSTOP';        {Do not Localize}
  Id_OS_NOS_2 = 'NOS-2';            {Do not Localize}
  Id_OS_NTOS  = 'NTOS';             {Do not Localize}
  Id_OS_OpenBSD = 'OPENBSD';        {Do not Localize}
  Id_OS_OpenVMS = 'OPENVMS';        {Do not Localize}
  Id_OS_OSDDP = 'OS/DDP';           {Do not Localize}
  Id_OS_OS_2 = 'OS/2';              {Do not Localize}
  Id_OS_OS_4 = 'OS4';               {Do not Localize}
  Id_OS_OS_6 = 'OS86';              {Do not Localize}
  Id_OS_OSX  = 'OSX';               {Do not Localize}
  Id_OS_PCDOS = 'PCDOS';            {Do not Localize}
  Id_OS_PERQOS = 'PERQ/OS';         {Do not Localize}
  Id_OS_PLI = 'PLI';                {Do not Localize}
  Id_OS_PSDDOSMIT = 'PSDOS/MIT';    {Do not Localize}
  Id_OS_Primos = 'PRIMOS';          {Do not Localize}
  Id_OS_RISC_OS = 'RISC-OS';        {Do not Localize}
  Id_OS_RISC_OS_3_10 = 'RISC-OS-3.10'; {Do not Localize}
  Id_OS_RISC_OS_3_50 = 'RISC-OS-3.50'; {Do not Localize}
  Id_OS_RISC_OS_3_60 = 'RISC-OS-3.60'; {Do not Localize}
  Id_OS_RISC_OS_3_70 = 'RISC-OS-3.70'; {Do not Localize}
  Id_OS_RISC_OS_4_00 = 'RISC-OS-4.00'; {Do not Localize}

  Id_OS_RMXRDOS = 'RMX/RDOS';          {Do not Localize}
  Id_OS_ROS = 'ROS';                   {Do not Localize}
  Id_OS_RSX11M = 'RSX11M';             {Do not Localize}
  Id_OS_RTE_A = 'RTE-A';               {Do not Localize}
  Id_OS_Satops = 'SATOPS';             {Do not Localize}
  Id_OS_Sinix  = 'SINIX';              {Do not Localize}
  Id_OS_SCO_Open_Desktop_1_0 = 'SCO-OPEN-DESKTOP-1.0'; {Do not Localize}
  Id_OS_SCO_Open_Desktop_1_1 = 'SCO-OPEN-DESKTOP-1.1'; {Do not Localize}
  Id_OS_SCO_Open_Desktop_2_0 = 'SCO-OPEN-DESKTOP-2.0'; {Do not Localize}
  Id_OS_SCO_Open_Desktop_3_0 = 'SCO-OPEN-DESKTOP-3.0'; {Do not Localize}
  Id_OS_SCO_Open_Desktop_Lite_3_0 = 'SCO-OPEN-DESKTOP-LITE-3.0'; {Do not Localize}
  Id_OS_SCO_Open_Server_3_0 = 'SCO-OPEN-SERVER-3.0';             {Do not Localize}
  Id_OS_SCO_Unix_3_2_0 = 'SCO-UNIX-3.2.0';                       {Do not Localize}
  Id_OS_SCO_Unix_3_2V2_0 = 'SCO-UNIX-3.2V2.0';                   {Do not Localize}
  Id_OS_SCO_Unix_3_2V1_0 = 'SCO-UNIX-3.2V2.1';                   {Do not Localize}
  Id_OS_SCO_Unix_S_2V4_0 = 'SCO-UNIX-3.2V4.0';                   {Do not Localize}
  Id_OS_SCO_Unix_3_2V4_1 = 'SCO-UNIX-3.2V4.1';                   {Do not Localize}
  Id_OS_SCO_Unix_3_2V4_2 = 'SCO-UNIX-3.2V4.2';                   {Do not Localize}
  Id_OS_SCO_Xenix_386_2_3_2 = 'SCO-XENIX-386-2.3.2';             {Do not Localize}
  Id_OS_SCO_Xenix_386_2_3_3 = 'SCO-XENIX-386-2.3.3';             {Do not Localize}
  Id_OS_SCO_Xenix_386_2_3_4 = 'SCO-XENIX-386-2.3.4';             {Do not Localize}
  Id_OS_SCS = 'SCS';                                             {Do not Localize}
  Id_OS_SIMP = 'SIMP';                                           {Do not Localize}
  Id_OS_SUN = 'SUN';                                             {Do not Localize}
  Id_OS_SUN_OS_3_5 = 'SUN-OS-3.5';                               {Do not Localize}
  Id_OS_SUN_OS_4_0 = 'SUN-OS-4.0';                               {Do not Localize}
  Id_OS_Swift = 'SWIFT';                                         {Do not Localize}
  Id_OS_Tac = 'TAC';                                             {Do not Localize}
  Id_OS_Tandem = 'TANDEM';                                       {Do not Localize}
  Id_OS_Tenex = 'TENEX';                                         {Do not Localize}
  Id_OS_The_Major_BBS = 'THE-MAJOR-BBS';                         {Do not Localize}
  Id_OS_Tops10 = 'TOPS10';                                       {Do not Localize}
  Id_OS_Tops20 = 'TOPS20';                                       {Do not Localize}
  Id_OS_TOS = 'TOS';                                             {Do not Localize}
  Id_OS_TP3010 = 'TP3010';                                       {Do not Localize}
  Id_OS_TRSDOS = 'TRSDOS';                                       {Do not Localize}
  Id_OS_Ultrix = 'ULTRIX';                                       {Do not Localize}
  Id_OS_Unix = 'UNIX';                                           {Do not Localize}
  Id_OS_Unix_BSD = 'UNIX-BSD';                                   {Do not Localize}
  Id_OS_Unix_V1AT = 'UNIX-V1AT';                                 {Do not Localize}
  Id_OS_Unix_V = 'UNIX-V';                                       {Do not Localize}
  Id_OS_Unix_V_1 = 'UNIX-V.1';                                   {Do not Localize}
  Id_OS_Unix_V_2 = 'UNIX-V.2';                                   {Do not Localize}
  Id_OS_Unix_V_3 = 'UNIX-V.3';                                   {Do not Localize}
  Id_OS_Unix_PC = 'UNIX-PC';                                     {Do not Localize}
  Id_OS_Unix_Unknown = 'UNKNOWN';                                {Do not Localize}
  Id_OS_UT2D = 'UT2D';                                           {Do not Localize}
  Id_OS_V = 'V';                                                 {Do not Localize}
  Id_OS_VM = 'VM';                                               {Do not Localize}
  Id_OS_VM_370 = 'VM/370';                                       {Do not Localize}
  Id_OS_VM_CMS = 'VM/CMS';                                       {Do not Localize}
  Id_OS_VM_SP = 'VM/SP';                                         {Do not Localize}
  Id_OS_VMS = 'VMS';                                             {Do not Localize}
  Id_OS_VMS_Eunice = 'VMS/EUNICE';                               {Do not Localize}
  Id_OS_VRTX = 'VRTX';                                           {Do not Localize}
  Id_OS_Waits = 'WAITS';                                         {Do not Localize}
  Id_OS_Wang = 'WANG';                                           {Do not Localize}
  Id_OS_Win32 = 'WIN32';                                         {Do not Localize}
  Id_OS_Windows_95 = 'WINDOWS-95';                               {Do not Localize}
  Id_OS_Windows_95OSR1 = 'WINDOWS-95-OSR1';                      {Do not Localize}
  Id_OS_Windows_95OSR2 = 'WINDOWS-95-OSR2';                      {Do not Localize}
  Id_OS_Windows_98     = 'WINDOWS-98';                           {Do not Localize}
  Id_OS_Windows_CE     = 'WINDOWS-CE';                           {Do not Localize}
  Id_OS_Windows_NT     = 'WINDOWS-NT';                           {Do not Localize}
  Id_OS_Windows_NT_2    = 'WINDOWS-NT-2';                        {Do not Localize}
  Id_OS_Windows_NT_3    = 'WINDOWS-NT-3';                        {Do not Localize}
  Id_OS_Windows_NT_3_5   = 'WINDOWS-NT-3.5';                     {Do not Localize}
  Id_OS_Windows_NT_3_51  = 'WINDOWS-NT-3.51';                    {Do not Localize}
  Id_OS_Windows_NT_4    = 'WINDOWS-NT-4';                        {Do not Localize}
  Id_OS_Windows_NT_5    = 'WINDOWS-NT-5';                        {Do not Localize}
  Id_OS_WorldGroup = 'WORLDGROUP';                               {Do not Localize}
  Id_OS_Wyse_Wyxware = 'WYSE-WYXWARE';                           {Do not Localize}
  Id_OS_X11R3 = 'X11R3';                                         {Do not Localize}
  Id_OS_XDE = 'XDE';                                             {Do not Localize}
  Id_OS_Xenix = 'XENIX';                                         {Do not Localize}

const
{ Machine Names }

  Id_MN_Amiga_500 = 'AMIGA-500';                   {Do not Localize}
  Id_MN_Amiga_500_010 = 'AMIGA-500/010';           {Do not Localize}
  Id_MN_Amiga_500_020 = 'AMIGA-500/020';           {Do not Localize}
  Id_MN_Amiga_500_EC030 = 'AMIGA-500/EC030';       {Do not Localize}
  Id_MN_Amiga_500_030 = 'AMIGA-500/030';           {Do not Localize}
  Id_MN_Amiga_600 = 'AMIGA-600';                   {Do not Localize}
  Id_MN_Amiga_1000 = 'AMIGA-1000';                 {Do not Localize}
  Id_MN_Amiga_1000_010 = 'AMIGA-1000/010';         {Do not Localize}
  Id_MN_Amiga_1000_020 = 'AMIGA-1000/020';         {Do not Localize}
  Id_MN_Amiga_1000_EC030 = 'AMIGA-1000/EC030';     {Do not Localize}
  Id_MN_Amiga_1000_030 = 'AMIGA-1000/030';         {Do not Localize}
  Id_MN_Amiga_1200 = 'AMIGA-1200';                 {Do not Localize}
  Id_MN_Amiga_1200_EC030 = 'AMIGA-1200/EC030';     {Do not Localize}
  Id_MN_Amiga_1200_030 = 'AMIGA-1200/030';         {Do not Localize}
  Id_MN_Amiga_1200_EC040 = 'AMIGA-1200/EC040';     {Do not Localize}
  Id_MN_Amiga_1200_LC040 = 'AMIGA-1200/LC040';     {Do not Localize}
  Id_MN_Amiga_1200_040 = 'AMIGA-1200/040';         {Do not Localize}
  Id_MN_Amiga_2000 = 'AMIGA-2000';                 {Do not Localize}
  Id_MN_Amiga_2000_010 = 'AMIGA-2000/010';         {Do not Localize}
  Id_MN_Amiga_2000_020 = 'AMIGA-2000/020';         {Do not Localize}
  Id_MN_Amiga_2000_EC030 = 'AMIGA-2000/EC030';     {Do not Localize}
  Id_MN_Amiga_2000_030 = 'AMIGA-2000/030';         {Do not Localize}
  Id_MN_Amiga_2000_LC040 = 'AMIGA-2000/LC040';     {Do not Localize}
  Id_MN_Amiga_2000_EC040 = 'AMIGA-2000/EC040';     {Do not Localize}
  Id_MN_Amiga_2000_040 = 'AMIGA-2000/040';         {Do not Localize}
  Id_MN_Amiga_3000 = 'AMIGA-3000';                 {Do not Localize}
  Id_MN_Amiga_3000_EC040 = 'AMIGA-3000/EC040';     {Do not Localize}
  Id_MN_Amiga_3000_LC040 = 'AMIGA-3000/LC040';     {Do not Localize}
  Id_MN_Amiga_3000_040 = 'AMIGA-3000/040';         {Do not Localize}
  Id_MN_Amiga_3000_060 = 'AMIGA-3000/060';         {Do not Localize}
  Id_MN_Amiga_4000_EC030 = 'AMIGA-4000/EC030';     {Do not Localize}
  Id_MN_Amiga_4000_030 = 'AMIGA-4000/030';         {Do not Localize}
  Id_MN_Amiga_4000_LC040 = 'AMIGA-4000/LC040';     {Do not Localize}
  Id_MN_Amiga_4000_040 = 'AMIGA-4000/040';         {Do not Localize}
  Id_MN_Amiga_4000_060 = 'AMIGA-4000/060';         {Do not Localize}
  Id_MN_Alto = 'ALTO';                             {Do not Localize}
  Id_MN_Altos_6800 = 'ALTOS-6800';                 {Do not Localize}
  Id_MN_Amdahl_V7 = 'AMDAHL-V7';                   {Do not Localize}
  Id_MN_Apollo = 'APOLLO';                         {Do not Localize}
  Id_MN_Apple_Macintosh = 'APPLE-MACINTOSH';       {Do not Localize}
  Id_MN_Apple_Powerbook = 'APPLE-POWERBOOK';       {Do not Localize}
  Id_MN_Atari_104ST = 'ATARI-104ST';               {Do not Localize}
  Id_MN_ATT_3B1 = 'ATT-3B1';                       {Do not Localize}
  Id_MN_ATT_3B2 = 'ATT-3B2';                       {Do not Localize}
  Id_MN_ATT_3B20 = 'ATT-3B20';                     {Do not Localize}
  Id_MN_ATT_7300 = 'ATT-7300';                     {Do not Localize}
  Id_MN_AXP = 'AXP';                               {Do not Localize}
  Id_MN_BBN_C_60 = 'BBN-C/60';                     {Do not Localize}
  Id_MN_Burroughs_B_29 = 'BURROUGHS-B/29';         {Do not Localize}
  Id_MN_Burroughs_B_4800 = 'BURROUGHS-B/4800';     {Do not Localize}
  Id_MN_Butterfly = 'BUTTERFLY';                   {Do not Localize}
  Id_MN_C_30 = 'C/30';                             {Do not Localize}
  Id_MN_C_70 = 'C/70';                             {Do not Localize}
  Id_MN_Cadlinc = 'CADLINC';                       {Do not Localize}
  Id_MN_CadR = 'CADR';                             {Do not Localize}
  Id_MN_CDC_170 = 'CDC-170';                       {Do not Localize}
  Id_MN_CDC_170_750 = 'CDC-170/750';               {Do not Localize}
  Id_MN_CDC_173 = 'CDC-173';                       {Do not Localize}
  Id_MN_CDTV = 'CDTV';                             {Do not Localize}
  Id_MN_CDTV_060 = 'CDTV/060';                     {Do not Localize}
  Id_MN_CD32 = 'CD32';                             {Do not Localize}
  Id_MN_Celerity_1200 = 'CELERITY-1200';           {Do not Localize}
  Id_MN_Club_386 = 'CLUB-386';                     {Do not Localize}
  Id_MN_Compaq_386_20 = 'COMPAQ-386/20';           {Do not Localize}
  Id_MN_Comten_3690 = 'COMTEN-3690';               {Do not Localize}
  Id_MN_CP8040 = 'CP8040';                         {Do not Localize}
  Id_MN_Cray_1 = 'CRAY-1';                         {Do not Localize}
  Id_MN_Cray_X_MP = 'CRAY-X/MP';                   {Do not Localize}
  Id_MN_Cray_2 = 'CRAY-2';                         {Do not Localize}
  Id_MN_CTIWS_117 = 'CTIWS-117';                   {Do not Localize}
  Id_MN_Dandelion = 'DANDELION';                   {Do not Localize}
  Id_MN_DEC_10 = 'DEC-10';                         {Do not Localize}
  Id_MN_DEC_1050 = 'DEC-1050';                     {Do not Localize}
  Id_MN_DEC_1077 = 'DEC-1077';                     {Do not Localize}
  Id_MN_DEC_1080 = 'DEC-1080';                     {Do not Localize}
  Id_MN_DEC_1090 = 'DEC-1090';                     {Do not Localize}
  Id_MN_DEC_1090B = 'DEC-1090B';                   {Do not Localize}
  Id_MN_DEC_1090T = 'DEC-1090T';                   {Do not Localize}
  Id_MN_DEC_2020T = 'DEC-2020T';                   {Do not Localize}
  Id_MN_DEC_2040 = 'DEC-2040';                     {Do not Localize}
  Id_MN_DEC_2040T = 'DEC-2040T';                   {Do not Localize}
  Id_MN_DEC_2050T = 'DEC-2050T';                   {Do not Localize}
  Id_MN_DEC_2060 = 'DEC-2060';                     {Do not Localize}
  Id_MN_DEC_2060T = 'DEC-2060T';                   {Do not Localize}
  Id_MN_DEC_2065 = 'DEC-2065';                     {Do not Localize}
  Id_MN_DEC_AXP = 'DEC-AXP';                       {Do not Localize}
  Id_MN_DEC_Falcon = 'DEC-FALCON';                 {Do not Localize}
  Id_MN_DEC_KS10 = 'DEC-KS10';                     {Do not Localize}
  Id_MN_DECStation = 'DECSTATION';                 {Do not Localize}
  Id_MN_DEC_VAX = 'DEC-VAX';                       {Do not Localize}
  Id_MN_DEC_VAXCluster = 'DEC-VAXCLUSTER';         {Do not Localize}
  Id_MN_DEC_VAXStation = 'DEC-VAXSTATION';         {Do not Localize}
  Id_MN_DEC_VAX_11730 = 'DEC-VAX-11730';           {Do not Localize}
  Id_MN_Dorado = 'DORADO';                         {Do not Localize}
  Id_MN_DPS8_70M = 'DPS8/70M';                     {Do not Localize}
  Id_MN_Elxsi_6400 = 'ELXSI-6400';                 {Do not Localize}
  Id_MN_EverEx_386 = 'EVEREX-386';                 {Do not Localize}
  Id_MN_Foonly_F2 = 'FOONLY-F2';                   {Do not Localize}
  Id_MN_Foonly_F3 = 'FOONLY-F3';                   {Do not Localize}
  Id_MN_Foonly_F4 = 'FOONLY-F4';                   {Do not Localize}
  Id_MN_Gould = 'GOULD';                           {Do not Localize}
  Id_MN_Gould_6050 = 'GOULD-6050';                 {Do not Localize}
  Id_MN_Gould_6080 = 'GOULD-6080';                 {Do not Localize}
  Id_MN_Gould_9050 = 'GOULD-9050';                 {Do not Localize}
  Id_MN_Gould_9080 = 'GOULD-9080';                 {Do not Localize}
  Id_MN_H_316 = 'H-316';                           {Do not Localize}
  Id_MN_H_60_68 = 'H-60/68';                       {Do not Localize}
  Id_MN_H_68 = 'H-68';                             {Do not Localize}
  Id_MN_H_68_80 = 'H-68/80';                       {Do not Localize}
  Id_MN_H_89 = 'H-89';                             {Do not Localize}
  Id_MN_Honeywell_DPS_6 = 'HONEYWELL-DPS-6';       {Do not Localize}
  Id_MN_Honeywell_BPS_8_70 = 'HONEYWELL-DPS-8/70'; {Do not Localize}
  Id_MN_HP3000 = 'HP3000';                         {Do not Localize}
  Id_MN_HP3000_64 = 'HP3000/64';                   {Do not Localize}
  Id_MN_IBM_158 = 'IBM-158';                       {Do not Localize}
  Id_MN_IBM_360_67 = 'IBM-360/67';                 {Do not Localize}
  Id_MN_IBM_370_3033 = 'IBM-370/3033';             {Do not Localize}
  Id_MN_IBM_3081 = 'IBM-3081';                     {Do not Localize}
  Id_MN_IBM_3084QX = 'IBM-3084QX';                 {Do not Localize}
  Id_MN_IBM_3101 = 'IBM-3101';                     {Do not Localize}
  Id_MN_IBM_4331 = 'IBM-4331';                     {Do not Localize}
  Id_MN_IBM_4341 = 'IBM-4341';                     {Do not Localize}
  Id_MN_IBM_4361 = 'IBM-4361';                     {Do not Localize}
  Id_MN_IBM_4381 = 'IBM-4381';                     {Do not Localize}
  Id_MN_IBM_4956 = 'IBM-4956';                     {Do not Localize}
  Id_MN_IBM_6152 = 'IBM-6152';                     {Do not Localize}
  Id_MN_IBM_PC = 'IBM-PC';                         {Do not Localize}
  Id_MN_IBM_PC_AT = 'IBM-PC/AT';                   {Do not Localize}
  Id_MN_IBM_PC_RT = 'IBM-PC/RT';                   {Do not Localize}
  Id_MN_IBM_PC_XT = 'IBM-PC/XT';                   {Do not Localize}
  Id_MN_IBM_RS_6000 = 'IBM-RS/6000';               {Do not Localize}
  Id_MN_IBM_Series_1 = 'IBM-SERIES/1';             {Do not Localize}

  Id_MN_Imagen = 'IMAGEN';                         {Do not Localize}
  Id_MN_Imagen_8_300 = 'IMAGEN-8/300';             {Do not Localize}
  Id_MN_Imsai = 'IMSAI';                           {Do not Localize}
  Id_MN_Integrated_Solutions = 'INTEGRATED-SOLUTIONS';                     {Do not Localize}
  Id_MN_Integrated_Solutions_68K = 'INTEGRATED-SOLUTIONS-68K';             {Do not Localize}
  Id_MN_Integrated_Solutions_Creator = 'INTEGRATED-SOLUTIONS-CREATOR';     {Do not Localize}
  Id_MN_Integrated_Solutions_Creator_8 = 'INTEGRATED-SOLUTIONS-CREATOR-8'; {Do not Localize}
  Id_MN_INTEL_386 = 'INTEL-386';                   {Do not Localize}
  Id_MN_INTEL_IPSC = 'INTEL-IPSC';                 {Do not Localize}
  Id_MN_Is_1 = 'IS-1';                             {Do not Localize}
  Id_MN_Is_68010 = 'IS-68010';                     {Do not Localize}
  Id_MN_LMI = 'LMI';                               {Do not Localize}
  Id_MN_LSI_11 = 'LSI-11';                         {Do not Localize}
  Id_MN_LSI_11_2 = 'LSI-11/2';                     {Do not Localize}
  Id_MN_LSI_11_23 = 'LSI-11/23';                   {Do not Localize}
  Id_MN_LSI_11_73 = 'LSI-11/73';                   {Do not Localize}
  Id_MN_M68000 = 'M68000';                         {Do not Localize}
  Id_MN_Mac_II = 'MAC-II';                         {Do not Localize}
  Id_MN_Mac_Powerbook = 'MAC-POWERBOOK';           {Do not Localize}
  Id_MN_MacIntosh = 'MACINTOSH';                   {Do not Localize}
  Id_MN_MassComp = 'MASSCOMP';                     {Do not Localize}
  Id_MN_MC500 = 'MC500';                           {Do not Localize}
  Id_MN_68000 = 'MC68000';                         {Do not Localize}
  Id_MN_Microport = 'MICROPORT';                   {Do not Localize}
  Id_MN_MicroVAX = 'MICROVAX';                     {Do not Localize}
  Id_MN_MicroVAX_I = 'MICROVAX-I';                 {Do not Localize}
  Id_MN_MV_8000 = 'MV/8000';                       {Do not Localize}
  Id_MN_NAS3_5 = 'NAS3-5';                         {Do not Localize}
  Id_MN_NCR_Comten_3690 = 'NCR-COMTEN-3690';       {Do not Localize}
  Id_MN_Next_N1000_316 = 'NEXT/N1000-316';         {Do not Localize}
  Id_MN_Now = 'NOW';                               {Do not Localize}
  Id_MN_Onyx_Z8000 = 'ONYX-Z8000';                 {Do not Localize}

  Id_MN_PDP_11 = 'PDP-11';                         {Do not Localize}
  Id_MN_PDP_11_3 = 'PDP-11/3';                     {Do not Localize}
  Id_MN_PDP_11_23 = 'PDP-11/23';                   {Do not Localize}
  Id_MN_PDP_11_24 = 'PDP-11/24';                   {Do not Localize}
  Id_MN_PDP_11_34 = 'PDP-11/34';                   {Do not Localize}
  Id_MN_PDP_11_40 = 'PDP-11/40';                   {Do not Localize}
  Id_MN_PDP_11_44 = 'PDP-11/44';                   {Do not Localize}
  Id_MN_PDP_11_45 = 'PDP-11/45';                   {Do not Localize}
  Id_MN_PDP_11_50 = 'PDP-11/50';                   {Do not Localize}
  Id_MN_PDP_11_70 = 'PDP-11/70';                   {Do not Localize}
  Id_MN_PDP_11_73 = 'PDP-11/73';                   {Do not Localize}
  Id_MN_PE_7_32 = 'PE-7/32';                       {Do not Localize}
  Id_MN_PE_3205 = 'PE-3205';                       {Do not Localize}
  Id_MN_PE_Perq = 'PERQ';                          {Do not Localize}
  Id_MN_Plexus_P_60 = 'PLEXUS-P/60';               {Do not Localize}
  Id_MN_PLI = 'PLI';                               {Do not Localize}

  Id_MN_Pluribus = 'PLURIBUS';                     {Do not Localize}
  Id_MN_Prime_2350 = 'PRIME-2350';                 {Do not Localize}
  Id_MN_Prime_2450 = 'PRIME-2450';                 {Do not Localize}
  Id_MN_Prime_2755 = 'PRIME-2755';                 {Do not Localize}
  Id_MN_Prime_9655 = 'PRIME-9655';                 {Do not Localize}
  Id_MN_Prime_9755 = 'PRIME-9755';                 {Do not Localize}
  Id_MN_Prime_9955II = 'PRIME-9955II';             {Do not Localize}
  Id_MN_Prime_2250 = 'PRIME-2250';                 {Do not Localize}
  Id_MN_Prime_2655 = 'PRIME-2655';                 {Do not Localize}
  Id_MN_Prime_9955 = 'PRIME-9955';                 {Do not Localize}
  Id_MN_Prime_9950 = 'PRIME-9950';                 {Do not Localize}
  Id_MN_Prime_9650 = 'PRIME-9650';                 {Do not Localize}
  Id_MN_Prime_9750 = 'PRIME-9750';                 {Do not Localize}
  Id_MN_Prime_750 = 'PRIME-750';                   {Do not Localize}
  Id_MN_Prime_850 = 'PRIME-850';                   {Do not Localize}
  Id_MN_Prime_550II = 'PRIME-550II';               {Do not Localize}
  Id_MN_Pyramid_90 = 'PYRAMID-90';                 {Do not Localize}
  Id_MN_Pyramid_90MX = 'PYRAMID-90MX';             {Do not Localize}
  Id_MN_Pyramid_90X = 'PYRAMID-90X';               {Do not Localize}
  Id_MN_Ridge = 'RIDGE';                           {Do not Localize}
  Id_MN_Ridge_32 = 'RIDGE-32';                     {Do not Localize}
  Id_MN_Ridge_32C = 'RIDGE-32C';                   {Do not Localize}
  Id_MN_ROLM_1666 = 'ROLM-1666';                   {Do not Localize}
  Id_MN_RS_6000 = 'RS/6000';                       {Do not Localize}
  Id_MN_S1_MKIIA = 'S1-MKIIA';                     {Do not Localize}
  Id_MN_SMI = 'SMI';                               {Do not Localize}
  Id_MN_Sequent_Balance_8000 = 'SEQUENT-BALANCE-8000'; {Do not Localize}
  Id_MN_Emens = 'SIEMENS';                         {Do not Localize}
  Id_MN_Silicon_Graphics = 'SILICON-GRAPHICS';     {Do not Localize}
  Id_MN_Silicon_Graphics_Iris = 'SILICON-GRAPHICS-IRIS'; {Do not Localize}

  Id_MN_SGI_Iris_2400 = 'SGI-IRIS-2400';           {Do not Localize}
  Id_MN_SGI_Iris_2500 = 'SGI-IRIS-2500';           {Do not Localize}
  Id_MN_SGI_Iris_3010 = 'SGI-IRIS-3010';           {Do not Localize}
  Id_MN_SGI_Iris_3020 = 'SGI-IRIS-3020';           {Do not Localize}
  Id_MN_SGI_Iris_3030 = 'SGI-IRIS-3030';           {Do not Localize}
  Id_MN_SGI_Iris_3110 = 'SGI-IRIS-3110';           {Do not Localize}
  Id_MN_SGI_Iris_3115 = 'SGI-IRIS-3115';           {Do not Localize}
  Id_MN_SGI_Iris_3120 = 'SGI-IRIS-3120';           {Do not Localize}
  Id_MN_SGI_Iris_3130 = 'SGI-IRIS-3130';           {Do not Localize}
  Id_MN_SGI_Iris_4D_20 = 'SGI-IRIS-4D/20';         {Do not Localize}
  Id_MN_SGI_Iris_4D_20G = 'SGI-IRIS-4D/20G';       {Do not Localize}
  Id_MN_SGI_Iris_4D_25 = 'SGI-IRIS-4D/25';         {Do not Localize}
  Id_MN_SGI_Iris_4D_25G = 'SGI-IRIS-4D/25G';       {Do not Localize}
  Id_MN_SGI_Iris_4D_25S = 'SGI-IRIS-4D/25S';       {Do not Localize}
  Id_MN_SGI_Iris_4D_50 = 'SGI-IRIS-4D/50';         {Do not Localize}
  Id_MN_SGI_Iris_4D_50G = 'SGI-IRIS-4D/50G';       {Do not Localize}
  Id_MN_SGI_Iris_4D_50GT = 'SGI-IRIS-4D/50GT';     {Do not Localize}
  Id_MN_SGI_Iris_4D_60 = 'SGI-IRIS-4D/60';         {Do not Localize}
  Id_MN_SGI_Iris_4D_60G = 'SGI-IRIS-4D/60G';       {Do not Localize}
  Id_MN_SGI_Iris_4D_60T = 'SGI-IRIS-4D/60T';       {Do not Localize}
  Id_MN_SGI_Iris_4D_60GT = 'SGI-IRIS-4D/60GT';     {Do not Localize}
  Id_MN_SGI_Iris_4D_70 = 'SGI-IRIS-4D/70';         {Do not Localize}
  Id_MN_SGI_Iris_4D_70G = 'SGI-IRIS-4D/70G';       {Do not Localize}
  Id_MN_SGI_Iris_4D_70GT = 'SGI-IRIS-4D/70GT';     {Do not Localize}
  Id_MN_SGI_Iris_4D_80GT = 'SGI-IRIS-4D/80GT';     {Do not Localize}
  Id_MN_SGI_Iris_4D_80S = 'SGI-IRIS-4D/80S';       {Do not Localize}
  Id_MN_SGI_Iris_4D_120GTX = 'SGI-IRIS-4D/120GTX'; {Do not Localize}
  Id_MN_SGI_Iris_4D_120S = 'SGI-IRIS-4D/120S';     {Do not Localize}
  Id_MN_SGI_Iris_4D_210GTX = 'SGI-IRIS-4D/210GTX'; {Do not Localize}
  Id_MN_SGI_Iris_4D_210S = 'SGI-IRIS-4D/210S';     {Do not Localize}
  Id_MN_SGI_Iris_4D_220GTX = 'SGI-IRIS-4D/220GTX'; {Do not Localize}
  Id_MN_SGI_Iris_4D_220S = 'SGI-IRIS-4D/220S';     {Do not Localize}
  Id_MN_SGI_Iris_4D_240GTX = 'SGI-IRIS-4D/240GTX'; {Do not Localize}
  Id_MN_SGI_Iris_4D_240S = 'SGI-IRIS-4D/240S';     {Do not Localize}
  Id_MN_SGI_Iris_4D_280GTX = 'SGI-IRIS-4D/280GTX'; {Do not Localize}
  Id_MN_SGI_Iris_4D_280S = 'SGI-IRIS-4D/280S';     {Do not Localize}
  Id_MN_SGI_Iris_CS_12 = 'SGI-IRIS-CS/12';         {Do not Localize}
  Id_MN_SGI_Iris_4Server_8 = 'SGI-IRIS-4SERVER-8'; {Do not Localize}
  Id_MN_Sperry_DCP_10 = 'SPERRY-DCP/10';           {Do not Localize}
  Id_MN_Sun = 'SUN';                               {Do not Localize}
  Id_MN_Sun_2 = 'SUN-2';                           {Do not Localize}
  Id_MN_Sun_2_50 = 'SUN-2/50';                     {Do not Localize}
  Id_MN_Sun_2_100 = 'SUN-2/100';                   {Do not Localize}
  Id_MN_Sun_2_120 = 'SUN-2/120';                   {Do not Localize}
  Id_MN_Sun_2_130 = 'SUN-2/130';                   {Do not Localize}
  Id_MN_Sun_2_140 = 'SUN-2/140';                   {Do not Localize}
  Id_MN_Sun_2_150 = 'SUN-2/150';                   {Do not Localize}
  Id_MN_Sun_2_160 = 'SUN-2/160';                   {Do not Localize}
  Id_MN_Sun_2_170 = 'SUN-2/170';                   {Do not Localize}
  Id_MN_Sun_3_50 = 'SUN-3/50';                     {Do not Localize}
  Id_MN_Sun_3_60 = 'SUN-3/60';                     {Do not Localize}
  Id_MN_Sun_3_75 = 'SUN-3/75';                     {Do not Localize}
  Id_MN_Sun_3_80 = 'SUN-3/80';                     {Do not Localize}
  Id_MN_Sun_3_110 = 'SUN-3/110';                   {Do not Localize}
  Id_MN_Sun_3_140 = 'SUN-3/140';                   {Do not Localize}
  Id_MN_Sun_3_150 = 'SUN-3/150';                   {Do not Localize}
  Id_MN_Sun_3_160 = 'SUN-3/160';                   {Do not Localize}
  Id_MN_Sun_3_180 = 'SUN-3/180';                   {Do not Localize}
  Id_MN_Sun_3_200 = 'SUN-3/200';                   {Do not Localize}
  Id_MN_Sun_3_260 = 'SUN-3/260';                   {Do not Localize}
  Id_MN_Sun_3_280 = 'SUN-3/280';                   {Do not Localize}
  Id_MN_Sun_3_470 = 'SUN-3/470';                   {Do not Localize}
  Id_MN_Sun_3_480 = 'SUN-3/480';                   {Do not Localize}
  Id_MN_Sun_4_60 = 'SUN-4/60';                     {Do not Localize}
  Id_MN_Sun_4_110 = 'SUN-4/110';                   {Do not Localize}
  Id_MN_Sun_4_150 = 'SUN-4/150';                   {Do not Localize}
  Id_MN_Sun_4_200 = 'SUN-4/200';                   {Do not Localize}
  Id_MN_Sun_4_260 = 'SUN-4/260';                   {Do not Localize}
  Id_MN_Sun_4_280 = 'SUN-4/280';                   {Do not Localize}
  Id_MN_Sun_4_330 = 'SUN-4/330';                   {Do not Localize}
  Id_MN_Sun_4_370 = 'SUN-4/370';                   {Do not Localize}
  Id_MN_Sun_4_390 = 'SUN-4/390';                   {Do not Localize}
  Id_MN_Sun_50 = 'SUN-50';                         {Do not Localize}
  Id_MN_Sun_100 = 'SUN-100';                       {Do not Localize}
  Id_MN_Sun_120 = 'SUN-120';                       {Do not Localize}
  Id_MN_Sun_130 = 'SUN-130';                       {Do not Localize}
  Id_MN_Sun_150 = 'SUN-150';                       {Do not Localize}
  Id_MN_Sun_170 = 'SUN-170';                       {Do not Localize}
  Id_MN_Sun_386i_250 = 'SUN-386i/250';             {Do not Localize}
  Id_MN_Sun_68000 = 'SUN-68000';                   {Do not Localize}
  Id_MN_Symbolics_3600 = 'SYMBOLICS-3600';         {Do not Localize}
  Id_MN_Symbolics_3670 = 'SYMBOLICS-3670';         {Do not Localize}
  Id_MN_Symmetric_375 = 'SYMMETRIC-375';           {Do not Localize}
  Id_MN_Symult = 'SYMULT';                         {Do not Localize}
  Id_MN_Tandem_TXP = 'TANDEM-TXP';                 {Do not Localize}
  Id_MN_Tandy_6000 = 'TANDY-6000';                 {Do not Localize}
  Id_MN_Tek_6130 = 'TEK-6130';                     {Do not Localize}
  Id_MN_TI_Explorer = 'TI-EXPLORER';               {Do not Localize}
  Id_MN_TP_4000 = 'TP-4000';                       {Do not Localize}
  Id_MN_TRS_80 = 'TRS-80';                         {Do not Localize}
  Id_MN_Univac_1100 = 'UNIVAC-1100';               {Do not Localize}
  Id_MN_Univac_1100_60 = 'UNIVAC-1100/60';         {Do not Localize}
  Id_MN_Univac_1100_62 = 'UNIVAC-1100/62';         {Do not Localize}
  Id_MN_Univac_1100_63 = 'UNIVAC-1100/63';         {Do not Localize}
  Id_MN_Univac_1100_64 = 'UNIVAC-1100/64';         {Do not Localize}
  Id_MN_Univac_1100_70 = 'UNIVAC-1100/70';         {Do not Localize}
  Id_MN_Univac_1160 = 'UNIVAC-1160';               {Do not Localize}
  Id_MN_Unknown = 'UNKNOWN';                       {Do not Localize}
  Id_MN_VAX = 'VAX';                               {Do not Localize}
  Id_MN_VAX_11_725 = 'VAX-11/725';                 {Do not Localize}
  Id_MN_VAX_11_730 = 'VAX-11/730';                 {Do not Localize}
  Id_MN_VAX_11_750 = 'VAX-11/750';                 {Do not Localize}
  Id_MN_VAX_11_780 = 'VAX-11/780';                 {Do not Localize}
  Id_MN_VAX_11_785 = 'VAX-11/785';                 {Do not Localize}
  Id_MN_VAX_11_790 = 'VAX-11/790';                 {Do not Localize}
  Id_MN_VAX_11_8600 = 'VAX-11/8600';               {Do not Localize}
  Id_MN_VAX_8600 = 'VAX-8600';                     {Do not Localize}
  Id_MN_VAXCluster = 'VAXCLUSTER';                 {Do not Localize}
  Id_MN_VAXStation = 'VAXSTATION';                 {Do not Localize}
  Id_MN_Wang_PC002 = 'WANG-PC002';                 {Do not Localize}
  Id_MN_Wang_VS100 = 'WANG-VS100';                 {Do not Localize}
  Id_MN_Wang_VS400 = 'WANG-VS400';                 {Do not Localize}
  Id_MN_Wyse_386 = 'WYSE-386';                     {Do not Localize}
  Id_MN_Wyse_WN5004 = 'WYSE-WN5004';               {Do not Localize}
  Id_MN_Wyse_WN5008 = 'WYSE-WN5008';               {Do not Localize}
  Id_MN_Wyse_WN5104 = 'WYSE-WN5104';               {Do not Localize}
  Id_MN_Wyse_WN5108 = 'WYSE-WN5108';               {Do not Localize}
  Id_MN_Wyse_WX15C = 'WYSE-WX15C';                 {Do not Localize}
  Id_MN_Wyse_WX17C = 'WYSE-WX17C';                 {Do not Localize}
  Id_MN_Wyse_WX17M = 'WYSE-WX17M';                 {Do not Localize}
  Id_MN_Wyse_WX19C = 'WYSE-WX19C';                 {Do not Localize}
  Id_MN_Wyse_WX19M = 'WYSE-WX19M';                 {Do not Localize}
  Id_MN_Wyse_WYX14M = 'WYSE-WYX14M';               {Do not Localize}
  Id_MN_Wyse_WYX5 = 'WYSE-WYX5';                   {Do not Localize}
  Id_MN_Xerox_1108 = 'XEROX-1108';                 {Do not Localize}
  Id_MN_Xerox_8010 = 'XEROX-8010';                 {Do not Localize}
  Id_MN_Zenith_148 = 'ZENITH-148';                 {Do not Localize}

const
  Id_CS_US_ASCII = 'US-ASCII';     // see ANSI_X3.4-1968 below   [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_1 = 'ISO-8859-1'; // see ISO_8859-1:1987 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_2 = 'ISO-8859-2'; // see ISO_8859-2:1987 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_3 = 'ISO-8859-3'; // see ISO_8859-3:1988 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_4 = 'ISO-8859-4'; // see ISO_8859-4:1988 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_5 = 'ISO-8859-5'; // see ISO_8859-5:1988 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_6 = 'ISO-8859-6'; // see ISO_8859-6:1987 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_7 = 'ISO-8859-7'; // see ISO_8859-7:1987 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_8 = 'ISO-8859-8'; // see ISO_8859-8:1988 below  [RFC1521,NSB]    {Do not Localize}
  Id_CS_ISO_8859_9 = 'ISO-8859-9'; // see ISO_8859-9:1989 below  {Do not Localize}

const
//These are multicast group IP addresses
  Id_IPMC_Base_Address = '224.0.0.0';      // Base Address [RFC1112,JBP]                  {Do not Localize}
  Id_IPMC_All_Systems = '224.0.0.1';       // All Systems on this Subne  [RFC1112,JBP]    {Do not Localize}
  Id_IPMC_All_Routers = '224.0.0.2';       // All Routers on this Subnet [JBP]            {Do not Localize}
  Id_IPMC_Unassigned = '224.0.0.3';        // Unassigned  [JBP]                           {Do not Localize}
  Id_IPMC_DVMRP_Routers = '224.0.0.4';     // DVMRP    Routers [RFC1075,JBP]              {Do not Localize}
  Id_IPMC_OSPFIGP_All_Routers = '224.0.0.5'; // OSPFIGP All Routers [RFC1583,JXM1]        {Do not Localize}
  Id_IPMC_OSPFIGP_Designated_Routers = '224.0.0.6'; //OSPFIGP Designated Routers [RFC1583,JXM1]  {Do not Localize}
Id_IPMC_ST_Routers = '224.0.0.7';         // ST Routers [RFC1190,KS14]                    {Do not Localize}
  Id_IPMC_ST_Hosts ='224.0.0.8';          // ST Hosts  [RFC1190,KS14]                     {Do not Localize}
  Id_IPMC_RIP2_Routers = '224.0.0.9';     // RIP2 Routers  [GSM11]                        {Do not Localize}
  Id_IPMC_IGRP_Routers = '224.0.0.10';    // IGRP Routers [Dino Farinacci]                {Do not Localize}
  Id_IPMC_Mobile_Agents ='224.0.0.11';    // Mobile-Agents [Bill Simpson]                 {Do not Localize}
//224.0.0.12-224.0.0.255 Unassigned [JBP]
  Id_IPMC_DHCP_Server = '224.0.0.12';     // DHCP Server / Relay Agent [RFC1884]          {Do not Localize}
  Id_IPMC_DHCP_All_PIM_Routers = '224.0.0.13'; // All PIM Routers [Farinacci]             {Do not Localize}
  Id_IPMC_RSVP_ENCAPSULATION = '224.0.0.14';   // RSVP-ENCAPSULATION [Braden]             {Do not Localize}
  Id_IPMC_All_CDT_Routers = '224.0.0.15';      // all-cbt-routers [Ballardie]             {Do not Localize}
  Id_IPMC_designated_sbm = '224.0.0.16';       // designated-sbm [Baker]                  {Do not Localize}
  Id_IPMC_ll_sbms = '224.0.0.17';              // all-sbms [Baker]                        {Do not Localize}
  Id_IPMC_VRRP = '224.0.0.18';                 // VRRP [Hinden]                           {Do not Localize}
  Id_IPMC_IPAllL1ISs = '224.0.0.19';           // IPAllL1ISs [Przygienda]                 {Do not Localize}
  Id_IPMC_IPAllL2ISs = '224.0.0.20';           // IPAllL2ISs [Przygienda]                 {Do not Localize}
  Id_IPMC_IPAllIntermediate_Systems = '224.0.0.21';// IPAllIntermediate Systems [Przygienda] {Do not Localize}
  Id_IPMC_IGMP = '224.0.0.22';                 // IGMP [Deering]                          {Do not Localize}
  Id_IPMC_GLOBECAST_ID = '224.0.0.23';         // GLOBECAST-ID [Scannell]                 {Do not Localize}
  //224.0.0.24 unassigned
  Id_IPMC_router_to_switch = '224.0.0.25';     // router-to-switch [Wu]                   {Do not Localize}
  //224.0.0.26 unassigned
  Id_IPMC_Al_MPP_Hello = '224.0.0.27';          // Al MPP Hello [Martinicky]              {Do not Localize}
  Id_IPMC_ETC_Control = '224.0.0.28';           // ETC Control [Polishinski]              {Do not Localize}
  Id_IPMC_GE_FANUC = '224.0.0.29';              // GE-FANUC [Wacey]                       {Do not Localize}
  Id_IPMC_INDIGO_VHDP = '224.0.0.30';           // indigo-vhdp [Caughie]                  {Do not Localize}
  Id_IPMC_shinbroadband = '224.0.0.31';         // shinbroadband [Kittivatcharapong]      {Do not Localize}
  Id_IPMC_digistar = '224.0.0.32';              // digistar [Kerkan]                      {Do not Localize}
  Id_IPMC_ff_system_Management = '224.0.0.33';  // ff-system-management [Glanzer]         {Do not Localize}
  Id_IPMC_pt2_discover = '224.0.0.34';          // pt2-discover [Kammerlander]            {Do not Localize}
  Id_IPMC_DXCLUSTER = '224.0.0.35';             // DXCLUSTER [Koopman]                    {Do not Localize}
  Id_IPMC_DTC_Announcement = '224.0.0.36';      // DTCP Announcement [Cipiere]            {Do not Localize}
  Id_IPMC_zeroconfaddr_Min = '224.0.0.37';      // zeroconfaddr (renew 12/02) [Guttman]   {Do not Localize}
  {Range}
  Id_IPMC_zeroconfaddr_Max = '224.0.0.68';          {Do not Localize}
  // 224.0.0.69-224.0.0.100 Reserved [IANA]
  Id_IPMC_Cisco_nhap = '224.0.0.101';           // cisco-nhap [Bakke]   {Do not Localize}
  Id_IPMC_HSPP = '224.0.0.102';                 // HSRP [Wilson]        {Do not Localize}
  Id_IPMC_MDAP = '224.0.0.103';                 // MDAP [Deleu]         {Do not Localize}
  // 224.0.0.104-224.0.0.250 Unassigned [JBP]
  Id_IPMC_mDNS = '224.0.0.251';                 // mDNS [Cheshire]      {Do not Localize}
  // 224.0.0.252-224.0.0.255 Unassigned [JBP]

  // 224.0.1.0 - 224.0.1.255  (224.0.1/24) Internetwork Control Block
  Id_IPMC_VMTP_Managers = '224.0.1.0';  // VMTP Managers Group  [RFC1045,DRC3]          {Do not Localize}
  Id_IPMC_NTP_Protocol = '224.0.1.1';   // NTP Network Time Protocol [RFC1119,DLM1]     {Do not Localize}
  Id_IPMC_SGI_Dogfight  ='224.0.1.2';   // SGI-Dogfight [AXC]                           {Do not Localize}
  Id_IPMC_Rwhod = '224.0.1.3';          // Rwhod [SXD]                                  {Do not Localize}
  Id_IPMC_VNP = '224.0.1.4';            // VNP  [DRC3]                                  {Do not Localize}
  Id_IPMC_Artificial_Horizons = '224.0.1.5';  // Artificial Horizons - Aviator [BXF]    {Do not Localize}
  Id_IPMC_NSS = '224.0.1.6';                  // NSS - Name Service Server [BXS2]       {Do not Localize}
  Id_IPMC_AUDIONEWS = '224.0.1.7';            // AUDIONEWS - Audio News Multicast [MXF2]{Do not Localize}
  Id_IPMC_SUN_NIS_Plus_Information = '224.0.1.8'; // SUN NIS+ Information Service [CXM3]{Do not Localize}
  Id_IPMC_MTP_Protocol = '224.0.1.9';         // MTP Multicast Transport Protocol [SXA] {Do not Localize}
  Id_IPMC_IETF_1_Low_Audio = '224.0.1.10';    // IETF-1-LOW-AUDIO [SC3]                 {Do not Localize}
  Id_IPMC_IETF_1_Audio = '224.0.1.11';        // IETF-1-AUDIO [SC3]                     {Do not Localize}
  Id_IPMC_IETF_1_Video = '224.0.1.12';        // IETF-1-VIDEO [SC3]                     {Do not Localize}
  Id_IPMC_IETF_2_Low_Audio = '224.0.1.13';    // IETF-2-LOW-AUDIO  [SC3]                {Do not Localize}
  Id_IPMC_IETF_2_Audio = '224.0.1.14';        // IETF-2-AUDIO [SC3]                     {Do not Localize}
  Id_IPMC_IETF_2_Video = '224.0.1.15';        // IETF-2-VIDEO [SC3]                     {Do not Localize}
  Id_IPMC_Music_Service = '224.0.1.16';       // MUSIC-SERVICE  [Guido van Rossum]      {Do not Localize}
  Id_IPMC_SEANET_TELEMETRY = '224.0.1.17';    // SEANET-TELEMETRY [Andrew Maffei]       {Do not Localize}
  Id_IPMC_SEANET_IMAGE = '224.0.1.18';        // SEANET-IMAGE  [Andrew Maffei]          {Do not Localize}
  Id_IPMC_MLOADD = '224.0.1.19';              // MLOADD [Braden]                        {Do not Localize}
  Id_IPMC_Private_Expiriment = '224.0.1.20';  // any private experiment [JBP]           {Do not Localize}
  Id_IPMC_DVMRP_on_MOSPF = '224.0.1.21';      // DVMRP on MOSPF [John Moy]              {Do not Localize}
  Id_IPMC_SVRLOC = '224.0.1.22';              // SVRLOC  <veizades@ftp.com>             {Do not Localize}
  Id_IPMC_XINGTV = '224.0.1.23';              // XINGTV <hgxing@aol.com>                {Do not Localize}
  Id_IPMC_Microsoft_DS = '224.0.1.24';        // microsoft-ds  <arnoldm@microsoft.com>  {Do not Localize}
  Id_IPMC_NBC_Pro = '224.0.1.25';             // nbc-pro <bloomer@birch.crd.ge.com>     {Do not Localize}
  Id_IPMC_NBC_Pfn = '224.0.1.26';             // nbc-pfn <bloomer@birch.crd.ge.com>     {Do not Localize}
  Id_IPMC_lmsc_calren_1 = '224.0.1.27';       // lmsc-calren-1  [Uang]                  {Do not Localize}
  Id_IPMC_lmsc_calren_2 = '224.0.1.28';       // lmsc-calren-2  [Uang]                  {Do not Localize}
  Id_IPMC_lmsc_calren_3 = '224.0.1.29';       // lmsc-calren-3  [Uang]                  {Do not Localize}
  Id_IPMC_lmsc_calren_4 = '224.0.1.30';       // lmsc-calren-4  [Uang]                  {Do not Localize}
  Id_IPMC_ampr_info = '224.0.1.31';           // ampr-info [Janssen]                    {Do not Localize}
  Id_IPMC_mtrace = '224.0.1.32';              // mtrace [Casner]                        {Do not Localize}
  Id_IPMC_RSVP_encap_1 = '224.0.1.33';        // RSVP-encap-1 [Braden]                  {Do not Localize}
  Id_IPMC_RSVP_encap_2 = '224.0.1.34';        // RSVP-encap-2 [Braden]                  {Do not Localize}
  Id_IPMC_SVRLOC_DA = '224.0.1.35';           // SVRLOC-DA [Veizades]                   {Do not Localize}
  Id_IPMC_rln_server = '224.0.1.36';          // rln-server [Kean]                      {Do not Localize}
  Id_IPMC_proshare_mc = '224.0.1.37';         // proshare-mc [Lewis]                    {Do not Localize}
  Id_IPMC_dantz = '224.0.1.38';               // dantz [Zulch]                          {Do not Localize}
  Id_IPMC_cisco_rp_announce = '224.0.1.39';   // cisco-rp-announce  [Farinacci]         {Do not Localize}
  Id_IPMC_cisco_rp_discovery = '224.0.1.40';  // cisco-rp-discovery [Farinacci]         {Do not Localize}
  Id_IPMC_gatekeeper  = '224.0.1.41';         // gatekeeper         [Toga]              {Do not Localize}
  Id_IPMC_iberiagames  = '224.0.1.42';        // iberiagames        [Marocho]           {Do not Localize}
  Id_IPMC_nwn_discovery = '224.0.1.43';       // nwn-discovery      [Zwemmer]           {Do not Localize}
  Id_IPMC_nwn_adaptor  = '224.0.1.44';        // nwn-adaptor        [Zwemmer]           {Do not Localize}
  Id_IPMC_isma_1 = '224.0.1.45';              // isma-1             [Dunne]             {Do not Localize}
  Id_IPMC_isma_2 = '224.0.1.46';              // isma-2             [Dunne]             {Do not Localize}

  Id_IPMC_telerate = '224.0.1.47';            // telerate           [Peng]              {Do not Localize}
  Id_IPMC_ciena = '224.0.1.48';               // ciena              [Rodbell]           {Do not Localize}
  Id_IPMC_dcap_servers = '224.0.1.49';        // dcap-servers       [RFC2114]           {Do not Localize}
  Id_IPMC_dcap_clients = '224.0.1.50';        // dcap-clients       [RFC2114]           {Do not Localize}
  Id_IPMC_mcntp_directory = '224.0.1.51';     // mcntp-directory    [Rupp]              {Do not Localize}
  Id_IPMC_mbone_vcr_directory = '224.0.1.52'; // mbone-vcr-directory[Holfelder]         {Do not Localize}
  Id_IPMC_heartbeat = '224.0.1.53';           // heartbeat          [Mamakos]           {Do not Localize}
  Id_IPMC_sun_mc_grp = '224.0.1.54';          // sun-mc-grp         [DeMoney]           {Do not Localize}
  Id_IPMC_extended_sys = '224.0.1.55';        // extended-sys       [Poole]             {Do not Localize}
  Id_IPMC_pdrncs = '224.0.1.56';              // pdrncs             [Wissenbach]        {Do not Localize}
  Id_IPMC_tns_adv_multi = '224.0.1.57';       // tns-adv-multi       [Albin]            {Do not Localize}
  Id_IPMC_vcals_dmu = '224.0.1.58';           // vcals-dmu           [Shindoh]          {Do not Localize}
  Id_IPMC_zuba = '224.0.1.59';                // zuba                [Jackson]          {Do not Localize}
  Id_IPMC_hp_device_disc = '224.0.1.60';      // hp-device-disc      [Albright]         {Do not Localize}
  Id_IPMC_tms_production = '224.0.1.61';      // tms-production      [Gilani]           {Do not Localize}
  Id_IPMC_sunscalar          = '224.0.1.62';  // sunscalar           [Gibson]           {Do not Localize}
  Id_IPMC_mmtp_poll = '224.0.1.63';           // mmtp-poll           [Costales]         {Do not Localize}
  Id_IPMC_compaq_peer = '224.0.1.64';         // compaq-peer         [Volpe]            {Do not Localize}
  Id_IPMC_iapp  = '224.0.1.65';               // iapp                [Meier]            {Do not Localize}
  Id_IPMC_multihasc_com = '224.0.1.66';       // multihasc-com       [Brockbank]        {Do not Localize}
  Id_IPMC_serv_discovery = '224.0.1.67';      // serv-discovery      [Honton]           {Do not Localize}
  Id_IPMC_mdhcpdisover = '224.0.1.68';        // mdhcpdisover        [RFC2730]          {Do not Localize}
  Id_IPMC_MMP_bundle_discovery1 = '224.0.1.69'; // MMP-bundle-discovery1 [Malkin]       {Do not Localize}
  Id_IPMC_MMP_bundle_discovery2 = '224.0.1.70'; // MMP-bundle-discovery2 [Malkin]       {Do not Localize}
  Id_IPMC_XYPOINT = '224.0.1.71';             // XYPOINT DGPS Data Feed  [Green]        {Do not Localize}
  Id_IPMC_GilatSkySurfer = '224.0.1.72';      // GilatSkySurfer    [Gal]                {Do not Localize}
  Id_IPMC_SharesLive = '224.0.1.73';          // SharesLive        [Rowatt]             {Do not Localize}
  Id_IPMC_NorthernData  = '224.0.1.74';       // NorthernData      [Sheers]             {Do not Localize}
  Id_IPMC_SIP = '224.0.1.75';                 // SIP               [Schulzrinne]        {Do not Localize}
  Id_IPMC_IAPP2 = '224.0.1.76';               // IAPP              [Moelard]            {Do not Localize}
  Id_IPMC_AGENTVIEW = '224.0.1.77';           // AGENTVIEW         [Iyer]               {Do not Localize}
  Id_IPMC_Tibco_1 = '224.0.1.78';             // Tibco Multicast1  [Shum]               {Do not Localize}
  Id_IPMC_Tibco_2 = '224.0.1.79';             // Tibco Multicast2  [Shum]               {Do not Localize}
  Id_IPMC_MSP = '224.0.1.80';                 // MSP               [Caves]              {Do not Localize}
  Id_IPMC_OTT = '224.0.1.81';                 // OTT (One-way Trip Time) [Schwartz]     {Do not Localize}
  Id_IPMC_TRACKTICKER = '224.0.1.82';         // TRACKTICKER       [Novick]             {Do not Localize}
  Id_IPMC_dtn_mc = '224.0.1.83';              // dtn-mc            [Gaddie]             {Do not Localize}
  Id_IPMC_jini_announcement = '224.0.1.84';   // jini-announcement [Scheifler]          {Do not Localize}
  Id_IPMC_jini_request = '224.0.1.85';        // jini-request      [Scheifler]          {Do not Localize}
  Id_IPMC_sde_discovery = '224.0.1.86';       // sde-discovery     [Aronson]            {Do not Localize}
  Id_IPMC_DirecPC_SI = '224.0.1.87';          // DirecPC-SI        [Dillon]             {Do not Localize}
  Id_IPMC_B1RMonitor = '224.0.1.88';          // B1RMonitor        [Purkiss]            {Do not Localize}
  Id_IPMC_3Com_AMP3 = '224.0.1.89';           // 3Com-AMP3 dRMON   [Banthia]            {Do not Localize}
  Id_IPMC_imFtmSvc = '224.0.1.90';            // imFtmSvc          [Bhatti]             {Do not Localize}
  Id_IPMC_NQDS4 = '224.0.1.91';               // NQDS4             [Flynn]              {Do not Localize}
  Id_IPMC_NQDS5 = '224.0.1.92';               // NQDS5             [Flynn]              {Do not Localize}
  Id_IPMC_NQDS6 = '224.0.1.93';               // NQDS6             [Flynn]              {Do not Localize}
  Id_IPMC_NLVL12 = '224.0.1.94';              // NLVL12            [Flynn]              {Do not Localize}
  Id_IPMC_NTDS1 = '224.0.1.95';               // NTDS1             [Flynn]              {Do not Localize}
  Id_IPMC_NTDS2 = '224.0.1.96';               // NTDS2             [Flynn]              {Do not Localize}
  Id_IPMC_NODSA = '224.0.1.97';               // NODSA             [Flynn]              {Do not Localize}
  Id_IPMC_NODSB = '224.0.1.98';               // NODSB             [Flynn]              {Do not Localize}
  Id_IPMC_NODSC = '224.0.1.99';               // NODSC             [Flynn]              {Do not Localize}
  Id_IPMC_NODSD = '224.0.1.100';              // NODSD             [Flynn]              {Do not Localize}
  Id_IPMC_NQDS4R = '224.0.1.101';             // NQDS4R            [Flynn]              {Do not Localize}
  Id_IPMC_NQDS5R = '224.0.1.102';             // NQDS5R            [Flynn]              {Do not Localize}
  Id_IPMC_NQDS6R = '224.0.1.103';             // NQDS6R            [Flynn]              {Do not Localize}
  Id_IPMC_NLVL12R = '224.0.1.104';            // NLVL12R           [Flynn]              {Do not Localize}
  Id_IPMC_NTDS1R = '224.0.1.105';             // NTDS1R            [Flynn]              {Do not Localize}
  Id_IPMC_NTDS2R = '224.0.1.106';             // NTDS2R            [Flynn]              {Do not Localize}
  Id_IPMC_NODSAR = '224.0.1.107';             // NODSAR            [Flynn]              {Do not Localize}
  Id_IPMC_NODSBR = '224.0.1.108';             // NODSBR            [Flynn]              {Do not Localize}
  Id_IPMC_NODSCR = '224.0.1.109';             // NODSCR            [Flynn]              {Do not Localize}
  Id_IPMC_NODSDR = '224.0.1.110';             // NODSDR            [Flynn]              {Do not Localize}
  Id_IPMC_MRM = '224.0.1.111';                // MRM               [Wei]                {Do not Localize}
  Id_IPMC_TVE_FILE = '224.0.1.112';           // TVE-FILE          [Blackketter]        {Do not Localize}
  Id_IPMC_TVE_ANNOUNCE = '224.0.1.113';       // TVE-ANNOUNCE      [Blackketter]        {Do not Localize}
  Id_IPMC_Mac = '224.0.1.114';                // Mac Srv Loc       [Woodcock]           {Do not Localize}
  Id_IPMC_Simple = '224.0.1.115';             // Simple Multicast  [Crowcroft]          {Do not Localize}
  Id_IPMC_SpectraLinkGW  = '224.0.1.116';     // SpectraLinkGW     [Hamilton]           {Do not Localize}
  Id_IPMC_dieboldmcast = '224.0.1.117';       // dieboldmcast      [Marsh]              {Do not Localize}
  Id_IPMC_Tivoli = '224.0.1.118';             // Tivoli Systems    [Gabriel]            {Do not Localize}
  Id_IPMC_pq_lic_mcast = '224.0.1.119';       // pq-lic-mcast      [Sledge]             {Do not Localize}
  Id_IPMC_HYPERFEED = '224.0.1.120';          // HYPERFEED         [Kreutzjans]         {Do not Localize}
  Id_IPMC_Pipesplatform = '224.0.1.121';      // Pipesplatform     [Dissett]            {Do not Localize}
  Id_IPMC_LiebDevMgmg_DM = '224.0.1.122';     // LiebDevMgmg-DM    [Velten]             {Do not Localize}
  Id_IPMC_TRIBALVOICE = '224.0.1.123';        // TRIBALVOICE       [Thompson]           {Do not Localize}
//  Id_IPMC_Unassigned = '//224.0.1.124'; //Unassigned (Retracted 1/29/01)              {Do not Localize}
  Id_IPMC_PolyCom = '224.0.1.125';            // PolyCom Relay1   [Coutiere]            {Do not Localize}
  Id_IPMC_Infront = '224.0.1.126';            // Infront Multi1   [Lindeman]            {Do not Localize}
  Id_IPMC_XRX = '224.0.1.127';                // XRX DEVICE DISC  [Wang]                {Do not Localize}
  Id_IPMC_CNN = '224.0.1.128';                // CNN              [Lynch]               {Do not Localize}
  Id_IPMC_PTP_primary = '224.0.1.129';        // PTP-primary      [Eidson]              {Do not Localize}
  Id_IPMC_PTP_alternate1 = '224.0.1.130';     // PTP-alternate1   [Eidson]              {Do not Localize}
  Id_IPMC_PTP_alternate2 = '224.0.1.131';     // PTP-alternate2   [Eidson]              {Do not Localize}
  Id_IPMC_PTP_alternate3 = '224.0.1.132';     // PTP-alternate3   [Eidson]              {Do not Localize}
  Id_IPMC_ProCast = '224.0.1.133';            // ProCast          [Revzen]              {Do not Localize}
  Id_IPMC_3Com = '224.0.1.134';               // 3Com Discp       [White]               {Do not Localize}
  Id_IPMC_CS_Multicasting = '224.0.1.135';    // CS-Multicasting  [Stanev]              {Do not Localize}
  Id_IPMC_TS_MC_1 = '224.0.1.136';            // TS-MC-1          [Sveistrup]           {Do not Localize}
  Id_IPMC_Make = '224.0.1.137';               // Make Source      [Daga]                {Do not Localize}
  Id_IPMC_Teleborsa = '224.0.1.138';          // Teleborsa        [Strazzera]           {Do not Localize}
  Id_IPMC_SUMAConfig = '224.0.1.139';         // SUMAConfig       [Wallach]             {Do not Localize}
//  Id_IPMC_Unassigned = '224.0.1.140'; //Unassigned                                    {Do not Localize}
  Id_IPMC_DHCP_SERVERS = '224.0.1.141';       // DHCP-SERVERS    [Hall]                 {Do not Localize}
  Id_IPMC_CN = '224.0.1.142';                 // CN Router-LL    [Armitage]             {Do not Localize}
  Id_IPMC_EMWIN = '224.0.1.143';              // EMWIN           [Querubin]             {Do not Localize}
  Id_IPMC_Alchemy = '224.0.1.144';            // Alchemy Cluster [O'Rourke]             {Do not Localize}
  Id_IPMC_Satcast_1 = '224.0.1.145';          // Satcast One     [Nevell]               {Do not Localize}
  Id_IPMC_Satcast_2 = '224.0.1.146';          // Satcast Two     [Nevell]               {Do not Localize}
  Id_IPMC_Satcast_3 = '224.0.1.147';          // Satcast Three   [Nevell]               {Do not Localize}
  Id_IPMC_Intline = '224.0.1.148';            // Intline         [Sliwinski]            {Do not Localize}
  Id_IPMC_8x8 = '224.0.1.149';                // 8x8 Multicast   [Roper]                {Do not Localize}
//  Id_IPMC__Unassigned = '224.0.1.150'; //Unassigned [JBP]                             {Do not Localize}
  Id_IPMC_Intline_1 = '224.0.1.151';          // Intline-1  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_2 = '224.0.1.152';          // Intline-2  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_3 = '224.0.1.153';          // Intline-3  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_4 = '224.0.1.154';          // Intline-4  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_5 = '224.0.1.155';          // Intline-5  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_6 = '224.0.1.156';          // Intline-6  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_7 = '224.0.1.157';          // Intline-7  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_8 = '224.0.1.158';          // Intline-8  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_9 = '224.0.1.159';          // Intline-9  [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_10 = '224.0.1.160';         // Intline-10 [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_11 = '224.0.1.161';         // Intline-11 [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_12 = '224.0.1.162';         // Intline-12 [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_13 = '224.0.1.163';         // Intline-13 [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_14 = '224.0.1.164';         // Intline-14 [Sliwinski]                 {Do not Localize}
  Id_IPMC_Intline_15 = '224.0.1.165';         // Intline-15 [Sliwinski]                 {Do not Localize}
  Id_IPMC_marratech_cc = '224.0.1.166';       // marratech-cc     [Parnes]              {Do not Localize}
  Id_IPMC_EMS_InterDev = '224.0.1.167';       // EMS-InterDev     [Lyda]                {Do not Localize}
  Id_IPMC_itb301 = '224.0.1.168';             // itb301           [Rueskamp]            {Do not Localize}
  Id_IPMC_rtv_audio = '224.0.1.169';          // rtv-audio        [Adams]               {Do not Localize}
  Id_IPMC_rtv_video = '224.0.1.170';          // rtv-video        [Adams]               {Do not Localize}
  Id_IPMC_HAVI_Sim = '224.0.1.171';           // HAVI-Sim         [Wasserroth]          {Do not Localize}
  Id_IPMC_Nokia = '224.0.1.172';              // Nokia Cluster    [O'Rourke]            {Do not Localize}
  Id_IPMC_host_request = '224.0.1.173';       // host-request     [K.Thompson]          {Do not Localize}
  Id_IPMC_host_announce = '224.0.1.174';      // host-announce    [K.Thompson]          {Do not Localize}
  Id_IPMC_ptk_cluster = '224.0.1.175';        // ptk-cluster      [Hodgson]             {Do not Localize}
  Id_IPMC_Proxim = '224.0.1.176';             // Proxim Protocol  [Shukla]              {Do not Localize}
  // Id_IPMC_Unassigned = '//224.0.1.177-224.0.1.255'; //Unassigned [JBP]               {Do not Localize}
  Id_IPMC_rwho = '224.0.2.1';                 // "rwho" Group (BSD) [JBP]               {Do not Localize}
  Id_IPMC_SUN = '224.0.2.2';                  // SUN RPC PMAPPROC_CALLIT [BXE1]         {Do not Localize}

  // 224.0.2.0 - 224.0.255.0   AD-HOC Block
  Id_IPMC_SIAC_Min = '224.0.2.064';                                                     {Do not Localize}
  Id_IPMC_SIAC_Max = '224.0.2.095';           // SIAC MDD Service        [Tse]          {Do not Localize}
  Id_IPMC_CoolCast_Min = '224.0.2.096';       // CoolCast                [Ballister]    {Do not Localize}
  Id_IPMC_CoolCast_Max = '224.0.2.127';       // CoolCast                [Ballister]    {Do not Localize}
  Id_IPMC_WOZ_Garage_Min = '224.0.2.128';     // WOZ-Garage              [Marquardt]    {Do not Localize}
  Id_IPMC_WOZ_Garage_Max = '224.0.2.191';     // WOZ-Garage              [Marquardt]    {Do not Localize}
  Id_IPMC_SIAC_Market_Min = '224.0.2.192';    // SIAC MDD Market Service [Lamberg]      {Do not Localize}
  Id_IPMC_SIAC_Market_Max = '224.0.2.255';    // SIAC MDD Market Service [Lamberg]      {Do not Localize}
  Id_IPMC_RFE_Generic_Min = '224.0.3.000';    // RFE Generic Service     [DXS3]         {Do not Localize}
  Id_IPMC_RFE_Generic_Max = '224.0.3.255';    // RFE Generic Service     [DXS3]         {Do not Localize}
  Id_IPMC_RFE_Individual_Min = '224.0.4.000'; // RFE Individual Conferences [DXS3]      {Do not Localize}
  Id_IPMC_RFE_Individual_Max = '224.0.4.255'; // RFE Individual Conferences [DXS3]      {Do not Localize}
  Id_IPMC_CDPD_Min = '224.0.5.000';                                                     {Do not Localize}
  Id_IPMC_CDPD_Max = '224.0.5.127';           // CDPD Groups          [Bob Brenner]     {Do not Localize}
  Id_IPMC_SIAC_Market2_Min = '224.0.5.128';   // SIAC Market Service  [Cho]             {Do not Localize}
  Id_IPMC_SIAC_Market2_Max = '224.0.5.191';                                             {Do not Localize}
  Id_IPMC_SIAC_MYSE_Min = '224.0.5.192';      // SIAC NYSE Order PDP protocol [Chan]    {Do not Localize}
  Id_IPMC_SIAC_MYSE_Max = '224.0.5.255';                                                {Do not Localize}
  Id_IPMC_Cornell_Min = '224.0.6.000';        // Cornell ISIS Project [Tim Clark]       {Do not Localize}
  Id_IPMC_Cornell_Max = '224.0.6.127';                                                  {Do not Localize}
 // Id_IPMC_Unassigned = '224.0.6.128-224.0.6.255'; //Unassigned [IANA]                 {Do not Localize}
  Id_IPMC_Where_Are_You_Min = '224.0.7.000';  // Where-Are-You         [Simpson]        {Do not Localize}
  Id_IPMC_Where_Are_You_Max = '224.0.7.255';                                            {Do not Localize}
  Id_IPMC_INTV_Min = '224.0.8.000';           // INTV                  [Tynan]          {Do not Localize}
  Id_IPMC_INTV_Max = '224.0.8.255';                                                     {Do not Localize}
  Id_IPMC_Invisible_Min = '224.0.9.000';      // Invisible Worlds      [Malamud]        {Do not Localize}
  Id_IPMC_Invisible_Max = '224.0.9.255';                                                {Do not Localize}
  Id_IPMC_DLSw_Min = '224.0.10.000';          // DLSw Groups           [Lee]            {Do not Localize}
  Id_IPMC_DLSw_Max = '224.0.10.255';                                                    {Do not Localize}
  Id_IPMC_NCC_NET_Min = '224.0.11.000';       // NCC.NET Audio         [Rubin]          {Do not Localize}
  Id_IPMC_NCC_NET_Max = '224.0.11.255';                                                 {Do not Localize}
  Id_IPMC_Microsoft_Min = '224.0.12.000';     // Microsoft and MSNBC   [Blank]          {Do not Localize}
  Id_IPMC_Microsoft_Max = '224.0.12.063';                                               {Do not Localize}
  Id_IPMC_UUNET_Min = '224.0.13.000';         // UUNET PIPEX  Net News [Barber]         {Do not Localize}
  Id_IPMC_UUNET_Max = '224.0.13.255';                                                   {Do not Localize}
  Id_IPMC_NLANR_Min = '224.0.14.000';         // NLANR                [Wessels]         {Do not Localize}
  Id_IPMC_NLANR_Max = '224.0.14.255';                                                   {Do not Localize}
  Id_IPMC_Hewlett_Min = '224.0.15.000';       // Hewlett Packard       [van der Meulen] {Do not Localize}
  Id_IPMC_Hewlett_Max = '224.0.15.255';                                                 {Do not Localize}
  Id_IPMC_XingNet_Min = '224.0.16.000';       // XingNet                [Uusitalo]      {Do not Localize}
  Id_IPMC_XingNet_Max = '224.0.16.255';                                                 {Do not Localize}
  Id_IPMC_Mercantile_Min = '224.0.17.000';    // Mercantile & CommodityExchange [Gilani]{Do not Localize}
  Id_IPMC_Mercantile_Max = '224.0.17.031';                                              {Do not Localize}
  Id_IPMC_NDQMD1_Min = '224.0.17.032';        // NDQMD1                 [Nelson]        {Do not Localize}
  Id_IPMC_NDQMD1_Max = '224.0.17.063';                                                  {Do not Localize}
  Id_IPMC_ODN_DTV_Min = '224.0.17.064';       // ODN-DTV                [Hodges]        {Do not Localize}
  Id_IPMC_ODN_DTV_Max = '224.0.17.127';                                                 {Do not Localize}
  Id_IPMC_Dow_Min = '224.0.18.000';           // Dow Jones             [Peng]           {Do not Localize}
  Id_IPMC_Dow_Max = '224.0.18.255';                                                     {Do not Localize}
  Id_IPMC_Walt_Min = '224.0.19.000';          // Walt Disney Company   [Watson]         {Do not Localize}
  Id_IPMC_Walt_Max = '224.0.19.063';                                                    {Do not Localize}
  Id_IPMC_Cal_Min = '224.0.19.064';           // Cal Multicast         [Moran]          {Do not Localize}
  Id_IPMC_Cal_Max = '224.0.19.095';                                                     {Do not Localize}
  Id_IPMC_SIAC_Market3_Min = '224.0.19.096';  // SIAC Market Service   [Roy]            {Do not Localize}
  Id_IPMC_SIAC_Market3_Max = '224.0.19.127';                                            {Do not Localize}
  Id_IPMC_IIG_Min = '224.0.19.128';           // IIG Multicast         [Carr]           {Do not Localize}
  Id_IPMC_IIG_Max = '224.0.19.191';                                                     {Do not Localize}
  Id_IPMC_Metropol_Min = '224.0.19.192';      // Metropol              [Crawford]       {Do not Localize}
  Id_IPMC_Metropol_Max = '224.0.19.207';                                                {Do not Localize}
  Id_IPMC_Xenoscience_Min = '224.0.19.208';   // Xenoscience, Inc.     [Timm]           {Do not Localize}
  Id_IPMC_Xenoscience_Max = '224.0.19.239';                                             {Do not Localize}
  Id_IPMC_HYPERFEED_Min = '224.0.19.240';     // HYPERFEED             [Felix]          {Do not Localize}
  Id_IPMC_HYPERFEED_Max = '224.0.19.255';                                               {Do not Localize}
  Id_IPMC_MS_IP_TV_Min = '224.0.20.000';      // MS-IP/TV              [Wong]           {Do not Localize}
  Id_IPMC_MS_IP_TV_Max = '224.0.20.063';                                                {Do not Localize}
  Id_IPMC_Reliable_Min = '224.0.20.064';      // Reliable Network Solutions [Vogels]    {Do not Localize}
  Id_IPMC_Reliable_Max = '224.0.20.127';                                                {Do not Localize}
  Id_IPMC_TRACKTICKER_Min = '224.0.20.128';   // TRACKTICKER Group     [Novick]         {Do not Localize}
  Id_IPMC_TRACKTICKER_Max = '224.0.20.143';                                             {Do not Localize}
  Id_IPMC_CNR_Min = '224.0.20.144';           // CNR Rebroadcast MCA   [Sautter]        {Do not Localize}
  Id_IPMC_CNR_Max = '224.0.20.207';                                                     {Do not Localize}
  Id_IPMC_Talarian_Min = '224.0.21.000';      // Talarian MCAST        [Mendal]         {Do not Localize}
  Id_IPMC_Talarian_Max = '224.0.21.127';                                                {Do not Localize}
  Id_IPMC_WORLD_Min = '224.0.22.000';         // WORLD MCAST           [Stewart]        {Do not Localize}
  Id_IPMC_WORLD_Max = '224.0.22.255';                                                   {Do not Localize}
  Id_IPMC_Domain_Min = '224.0.252.000';       // Domain Scoped Group   [Fenner]         {Do not Localize}
  Id_IPMC_Domain_Max = '224.0.252.000-224.0.252.255';                                   {Do not Localize}
  Id_IPMC_Report_Min = '224.0.253.000';       //Report Group           [Fenner]         {Do not Localize}
  Id_IPMC_Report_Max = '224.0.253.255';                                                 {Do not Localize}
  Id_IPMC_Query_Min = '224.0.254.000';        //Query Group            [Fenner]         {Do not Localize}
  Id_IPMC_Query_Max = '224.0.254.255';                                                  {Do not Localize}
  Id_IPMC_Border_Min = '224.0.255.000';       //Border Routers         [Fenner]         {Do not Localize}
  Id_IPMC_Border_Max = '224.0.255.255';                                                 {Do not Localize}

  // 224.1.0.0 - 224.1.255.255 (224.1/16) ST Multicast Groups [RFC1190,KS14]
  Id_IPMC_Multimedia_Min = '224.2.0.0';       // Multimedia Conference Calls [SC3]      {Do not Localize}
  Id_IPMC_Multimedia_Max = '224.2.127.253';   // Multimedia Conference Calls [SC3]      {Do not Localize}
  Id_IPMC_SAPv1 = '224.2.127.254';            // SAPv1 Announcements         [SC3]      {Do not Localize}
  Id_IPMC_SAPv0 = '224.2.127.255';            // SAPv0 Announcements         [SC3]      {Do not Localize}
  Id_IPMC_SAP_Min = '224.2.128.0';            // SAP Dynamic Assignments     [SC3]      {Do not Localize}
  Id_IPMC_SAP_Max = '224.2.255.255';          // SAP Dynamic Assignments     [SC3]      {Do not Localize}

  // Id_IPMC_Reserved_Min = '224.3.0.0'; // Reserved [IANA]                             {Do not Localize}
  // Id_IPMC_Reserved_Max = '224.251.255.255'; // Reserved [IANA]                       {Do not Localize}
  Id_IPMC_DIS_Min = '224.252.000.000';          // DIS Transient Groups [IANA]          {Do not Localize}
  Id_IPMC_DIS_Max = '224.255.255.255';          // DIS Transient Groups [IANA]          {Do not Localize}
  // Id_IPMC_Reserved_Min = '225.000.000.000';  // Reserved [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Max = '231.255.255.255';  // Reserved [IANA]                      {Do not Localize}
  Id_IPMC_Source_Min = '232.000.000.000';       // Source Specific Multicast [DRC3]     {Do not Localize}
  Id_IPMC_Source_Max = '232.255.255.255';       // Source Specific Multicast [DRC3]     {Do not Localize}
  Id_IPMC_GLOP_Min = '233.000.000.000';         // GLOP Block [RFC3180]                 {Do not Localize}
  Id_IPMC_GLOP_Max = '233.255.255.255';         // GLOP Block [RFC3180]                 {Do not Localize}
  // Id_IPMC_Reserved_Min = '234.000.000.000';  // Reserved [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Max = '238.255.255.255';  // Reserved [IANA]                      {Do not Localize}
  Id_IPMC_Administratively_Min = '239.000.000.000'; // Administratively Scoped [IANA,RFC2365]  {Do not Localize}
  Id_IPMC_Administratively_Max = '239.255.255.255'; // Administratively Scoped [IANA,RFC2365]  {Do not Localize}
  // Id_IPMC_Reserved_Min = '239.000.000.000'; // Reserved  [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Max = '239.063.255.255'; // Reserved  [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Min = '239.064.000.000'; // Reserved  [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Max = '239.127.255.255'; // Reserved  [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Min = '239.128.000.000'; // Reserved  [IANA]                      {Do not Localize}
  // Id_IPMC_Reserved_Max = '239.191.255.255'; // Reserved  [IANA]                      {Do not Localize}
  Id_IPMC_Organization_Local_Min = '239.192.000.000'; // Organization-Local Scope   [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Organization_Local_Max = '239.251.255.255'; // Organization-Local Scope   [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local1_Min = '239.252.000.000';        // Site-Local Scope(reserved) [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local1_Max = '239.252.255.255';        // Site-Local Scope(reserved) [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local2_Min = '239.253.000.000';        // Site-Local Scope(reserved) [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local2_Max = '239.253.255.255';        // Site-Local Scope(reserved) [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local3_Min = '239.254.000.000';        // Site-Local Scope(reserved) [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local3_Max = '239.254.255.255';        // Site-Local Scope(reserved) [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local4_Min = '239.255.000.000';        // Site-Local Scope           [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_Site_Local4_Max = '239.255.255.255';        // Site-Local Scope           [Meyer,RFC2365] {Do not Localize}
  Id_IPMC_rasadv = '239.255.002.002'; // rasadv [Thaler]                                {Do not Localize}

{
  There is a concept of relative addresses to be used with the scoped
  multicast addresses.  These relative addresses are listed here:

  Relative              Description                                       Reference
  --------------------- ------------------------------------------------- ---------
}
  Id_IPREL_SAP =  0;    // SAP Session Announcement Protocol              [Handley]
  Id_IPREL_MADCAP = 1;  // MADCAP Protocol                                [RFC2730]
  Id_IPREL_SLPV2 = 2;   // SLPv2 Discovery                                [Guttman]
  Id_IPREL_MZAP = 3;    // MZAP                                           [Thaler]
  Id_IPREL_DNS = 4;     // Multicast Discovery of DNS Services            [Manning]
  Id_IPREL_SSDP = 5;    // SSDP                                           [Goland]
  Id_IPREL_DHCPV4 = 6;  // DHCP v4                                        [Hall]
  Id_IPREL_AAP = 7;     // AAP                                            [Hanna]
  Id_IPREL_MBUS = 8;    // MBUS                                           [Kutscher]
//  9-252      Reserved - To be assigned by the IANA
//  253        Reserved
//  254-255    Reserved - To be assigned by the IANA

implementation

end.
